/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpellEntity
extends ThrowableProjectile {
    public int color = 0;
    public static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(SpellEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public SpellEntity(EntityType<? extends SpellEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean isInWater() {
        return false;
    }

    public double getDefaultGravity() {
        return 0.005;
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Color", this.getColor());
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(COLOR, (Object)this.color);
    }

    public void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        this.discard();
    }

    public void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        this.discard();
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setColor(pCompound.getInt("Color"));
    }

    public void setColor(int pColor) {
        this.entityData.set(COLOR, (Object)pColor);
    }
}

