/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.menu.StorageVaseMenu;
import com.axanthic.icaria.common.registry.IcariaBlockEntityTypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StorageVaseBlockEntity
extends RandomizableContainerBlockEntity {
    public int size = 32;
    public NonNullList<ItemStack> items = NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY);

    public StorageVaseBlockEntity(BlockPos pPos, BlockState pState) {
        super(IcariaBlockEntityTypes.STORAGE_VASE.get(), pPos, pState);
    }

    public int getContainerSize() {
        return this.size;
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pProvider) {
        super.loadAdditional(pTag, pProvider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(pTag)) {
            ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pProvider);
        }
    }

    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pProvider) {
        super.saveAdditional(pTag, pProvider);
        if (!this.trySaveLootTable(pTag)) {
            ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pProvider);
        }
    }

    public void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return StorageVaseMenu.menu(pContainerId, pInventory, (Container)this);
    }

    public Component getDefaultName() {
        return Component.translatable((String)"menu.landsoficaria.storage_vase");
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }
}

