/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VinegarEntity
extends AbstractArrow {
    public ItemStack stack = new ItemStack((ItemLike)IcariaItems.VINEGAR.get());

    public VinegarEntity(EntityType<? extends VinegarEntity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public VinegarEntity(Level pLevel, LivingEntity pEntity, ItemStack pStack) {
        super(IcariaEntityTypes.VINEGAR.get(), pEntity, pLevel, pStack, null);
        this.stack = pStack.copy();
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void onHit(HitResult pResult) {
        this.discard();
    }

    public void playerTouch(Player pEntity) {
        pEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 120, 0), (Entity)this);
        pEntity.hurt(this.damageSources().mobProjectile((Entity)this, (LivingEntity)pEntity), 2.0f);
    }

    public ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public ItemStack getItem() {
        return this.stack;
    }
}

