/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.IcariaArachnidEntity;
import com.axanthic.icaria.common.entity.VinegarEntity;
import com.axanthic.icaria.common.goal.IcariaArachnidTargetGoal;
import com.axanthic.icaria.common.math.IcariaMath;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VinegaroonEntity
extends IcariaArachnidEntity
implements RangedAttackMob {
    public int maxCooldown = 120;
    public int minCooldown = 0;
    public AnimationState attackAnimationState = new AnimationState();
    public static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.defineId(VinegaroonEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Integer> COOLDOWN = SynchedEntityData.defineId(VinegaroonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public VinegaroonEntity(EntityType<? extends VinegaroonEntity> pType, Level pLevel) {
        super(pType, pLevel);
        this.xpReward = 5;
    }

    public boolean canBeAffected(MobEffectInstance pEffectInstance) {
        return super.canBeAffected(pEffectInstance) && !pEffectInstance.is(MobEffects.POISON);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean doHurtTarget(Entity pEntity) {
        pEntity.startRiding((Entity)this);
        return super.doHurtTarget(pEntity);
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(CLIMBING) & 1) != 0;
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public boolean onCooldown() {
        return this.getCooldown() > this.minCooldown;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public float getHalfHealth() {
        return this.getMaxHealth() * 0.5f;
    }

    public int getCooldown() {
        return (Integer)this.entityData.get(COOLDOWN);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Cooldown", this.getCooldown());
    }

    public void aiStep() {
        int cooldown;
        super.aiStep();
        if (this.onCooldown() && (cooldown = this.getCooldown()) > this.minCooldown) {
            this.setCooldown(--cooldown);
        }
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(CLIMBING, (Object)0);
        pBuilder.define(COOLDOWN, (Object)this.minCooldown);
    }

    public void makeStuckInBlock(BlockState pState, Vec3 pMotionMultiplier) {
        if (!pState.is(IcariaBlockTags.COBWEB_BLOCKS)) {
            super.makeStuckInBlock(pState, pMotionMultiplier);
        }
    }

    public void performRangedAttack(LivingEntity pTarget, float pVelocity) {
        VinegarEntity entity = new VinegarEntity(this.level(), (LivingEntity)this, this.useItem);
        double d0 = pTarget.getX() - this.getX();
        double d1 = pTarget.getY() - entity.getY();
        double d2 = pTarget.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        entity.shoot(d0, d1 + d3 * 0.2, d2, 2.0f, 2.0f);
        this.level().addFreshEntity((Entity)entity);
        if (!this.isSilent()) {
            this.level().playSound(null, this.blockPosition(), IcariaSoundEvents.VINEGAROON_SHOOT, SoundSource.HOSTILE);
        }
    }

    public void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound(IcariaSoundEvents.VINEGAROON_STEP, 0.1f, 1.0f);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setCooldown(pCompound.getInt("Cooldown"));
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f, 0.025f, false));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new IcariaArachnidTargetGoal<Player>((Mob)this, Player.class, true, true));
    }

    public void setClimbing(boolean pClimbing) {
        byte b = (Byte)this.entityData.get(CLIMBING);
        b = pClimbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.entityData.set(CLIMBING, (Object)b);
    }

    public void setCooldown(int pCooldown) {
        int ticks = Mth.clamp((int)pCooldown, (int)this.minCooldown, (int)this.maxCooldown);
        this.entityData.set(COOLDOWN, (Object)ticks);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (this.onCooldown()) {
                this.attackAnimationState.startIfStopped(this.tickCount);
            } else {
                this.attackAnimationState.stop();
            }
        } else {
            float distance;
            this.setClimbing(this.horizontalCollision);
            if (this.hasExactlyOnePlayerPassenger()) {
                Player player;
                Entity entity = this.getFirstPassenger();
                if (entity instanceof Player && !(player = (Player)entity).isCreative()) {
                    player.setShiftKeyDown(false);
                    if (this.getHealth() < this.getHalfHealth()) {
                        player.stopRiding();
                    }
                }
            } else if (this.getTarget() != null && (distance = this.distanceTo((Entity)this.getTarget())) >= 4.0f && !this.onCooldown()) {
                this.performRangedAttack(this.getTarget(), distance);
                this.setCooldown(this.maxCooldown);
            }
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ARMOR, 8.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MAX_HEALTH, 32.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public PathNavigation createNavigation(Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    public SoundEvent getAmbientSound() {
        return IcariaSoundEvents.VINEGAROON_AMBIENT;
    }

    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.VINEGAROON_DEATH;
    }

    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.VINEGAROON_HURT;
    }

    public Vec3 getPassengerAttachmentPoint(Entity pEntity, EntityDimensions pDimensions, float pScale) {
        return new Vec3(0.0, (double)pDimensions.height(), 0.9375).yRot(IcariaMath.rad(-this.getYHeadRot()));
    }
}

