/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.events;

import com.axanthic.icaria.common.item.BidentItem;
import com.axanthic.icaria.common.item.ScytheItem;
import com.axanthic.icaria.common.item.TotemItem;
import com.axanthic.icaria.common.network.packet.TotemPacket;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaMobEffects;
import com.axanthic.icaria.common.registry.IcariaPotions;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="landsoficaria")
public class CommonGameEvents {
    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent pEvent) {
        LevelAccessor level = pEvent.getLevel();
        Player player = pEvent.getPlayer();
        BlockPos pos = pEvent.getPos();
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof ScytheItem && stack.isCorrectToolForDrops(level.getBlockState(pos))) {
            for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)pos, (int)1, (int)1, (int)1)) {
                if (!stack.isCorrectToolForDrops(level.getBlockState(blockPos))) continue;
                level.destroyBlock(blockPos, true, (Entity)player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingIncomingDamage(LivingIncomingDamageEvent pEvent) {
        Entity health2;
        Player player;
        float amount = pEvent.getAmount();
        LivingEntity livingEntity = pEvent.getEntity();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            float health2 = player.getHealth();
            FoodData foodData = player.getFoodData();
            ItemStack mainHandItem = player.getMainHandItem();
            ItemStack offhandItem = player.getOffhandItem();
            TotemItem totem = IcariaItems.TOTEM_OF_STUFFING.get();
            if (foodData.getFoodLevel() <= 0) {
                if (mainHandItem.getItem().equals((Object)totem)) {
                    foodData.setFoodLevel(20);
                    foodData.setSaturation(20.0f);
                    mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 200));
                    player.awardStat(Stats.ITEM_USED.get((Object)totem));
                    player.removeEffect(MobEffects.HUNGER);
                    player.setHealth(health2 + amount);
                    CommonGameEvents.sendPacket(totem, player);
                } else if (offhandItem.getItem().equals((Object)totem)) {
                    foodData.setFoodLevel(20);
                    foodData.setSaturation(20.0f);
                    offhandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    player.addEffect(new MobEffectInstance(MobEffects.SATURATION, 200));
                    player.awardStat(Stats.ITEM_USED.get((Object)totem));
                    player.removeEffect(MobEffects.HUNGER);
                    player.setHealth(health2 + amount);
                    CommonGameEvents.sendPacket(totem, player);
                }
            }
            totem = IcariaItems.TOTEM_OF_UNDROWNING.get();
            if (player.getAirSupply() <= 0) {
                if (mainHandItem.getItem().equals((Object)totem)) {
                    mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 600));
                    player.awardStat(Stats.ITEM_USED.get((Object)totem));
                    player.setAirSupply(300);
                    player.setHealth(health2 + amount);
                    CommonGameEvents.sendPacket(totem, player);
                } else if (offhandItem.getItem().equals((Object)totem)) {
                    offhandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 600));
                    player.awardStat(Stats.ITEM_USED.get((Object)totem));
                    player.setAirSupply(300);
                    player.setHealth(health2 + amount);
                    CommonGameEvents.sendPacket(totem, player);
                }
            }
            totem = IcariaItems.TOTEM_OF_UNSINKING.get();
            if (player.blockPosition().getY() <= -64) {
                if (mainHandItem.getItem().equals((Object)totem)) {
                    mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 600));
                    player.awardStat(Stats.ITEM_USED.get((Object)totem));
                    player.teleportTo((double)player.blockPosition().getX() + 0.5, 320.0, (double)player.blockPosition().getZ() + 0.5);
                    player.setHealth(health2 + amount);
                    CommonGameEvents.sendPacket(totem, player);
                } else if (offhandItem.getItem().equals((Object)totem)) {
                    offhandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 600));
                    player.awardStat(Stats.ITEM_USED.get((Object)totem));
                    player.teleportTo((double)player.blockPosition().getX() + 0.5, 320.0, (double)player.blockPosition().getZ() + 0.5);
                    player.setHealth(health2 + amount);
                    CommonGameEvents.sendPacket(totem, player);
                }
            }
            totem = IcariaItems.TOTEM_OF_UNSHATTERING.get();
            for (int slot = 5; slot < 9; ++slot) {
                ItemStack itemStack = ((Slot)player.inventoryMenu.slots.get(slot)).getItem();
                if (!(itemStack.getItem() instanceof ArmorItem) || !((float)itemStack.getDamageValue() >= (float)itemStack.getMaxDamage() * 0.9f)) continue;
                if (mainHandItem.getItem().equals((Object)totem)) {
                    itemStack.setDamageValue((int)((float)itemStack.getItem().getMaxDamage(itemStack) * 0.1f));
                    mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    player.awardStat(Stats.ITEM_USED.get((Object)totem));
                    CommonGameEvents.sendPacket(totem, player);
                    continue;
                }
                if (!offhandItem.getItem().equals((Object)totem)) continue;
                itemStack.setDamageValue((int)((float)itemStack.getItem().getMaxDamage(itemStack) * 0.1f));
                offhandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                player.awardStat(Stats.ITEM_USED.get((Object)totem));
                CommonGameEvents.sendPacket(totem, player);
            }
        }
        if ((health2 = pEvent.getSource().getEntity()) instanceof Player) {
            player = (Player)health2;
            ItemStack mainHandItem = player.getMainHandItem();
            ItemStack offhandItem = player.getOffhandItem();
            TotemItem totem = IcariaItems.TOTEM_OF_UNSHATTERING.get();
            if (mainHandItem.getItem().equals((Object)totem)) {
                if ((double)offhandItem.getDamageValue() >= (double)offhandItem.getMaxDamage() * 0.9 && (offhandItem.getItem() instanceof TieredItem || offhandItem.getItem() instanceof TridentItem)) {
                    mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    offhandItem.setDamageValue((int)((float)offhandItem.getItem().getMaxDamage(offhandItem) * 0.1f));
                    player.awardStat(Stats.ITEM_USED.get((Object)totem));
                    CommonGameEvents.sendPacket(totem, player);
                }
            } else if (offhandItem.getItem().equals((Object)totem) && (double)mainHandItem.getDamageValue() >= (double)mainHandItem.getMaxDamage() * 0.9 && (mainHandItem.getItem() instanceof TieredItem || mainHandItem.getItem() instanceof TridentItem)) {
                mainHandItem.setDamageValue((int)((float)mainHandItem.getItem().getMaxDamage(mainHandItem) * 0.1f));
                offhandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                player.awardStat(Stats.ITEM_USED.get((Object)totem));
                CommonGameEvents.sendPacket(totem, player);
            }
            if (player.hasEffect(IcariaMobEffects.LIFESTEAL)) {
                player.heal(amount);
            }
        }
    }

    @SubscribeEvent
    public static void onMobEffectApplicable(MobEffectEvent.Applicable pEvent) {
        MobEffectInstance effectInstance = pEvent.getEffectInstance();
        TotemItem totem = IcariaItems.TOTEM_OF_UNBLINDING.get();
        if (effectInstance != null) {
            Holder effect = effectInstance.getEffect();
            LivingEntity livingEntity = pEvent.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ItemStack mainHandItem = player.getMainHandItem();
                ItemStack offhandItem = player.getOffhandItem();
                if (effect.equals((Object)MobEffects.BLINDNESS) || effect.equals((Object)MobEffects.DARKNESS)) {
                    if (mainHandItem.getItem().equals((Object)totem)) {
                        mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                        player.addEffect(new MobEffectInstance(IcariaMobEffects.BLINDNESS_IMMUNITY, 600));
                        player.awardStat(Stats.ITEM_USED.get((Object)totem));
                        CommonGameEvents.sendPacket(totem, player);
                    } else if (offhandItem.getItem().equals((Object)totem)) {
                        offhandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                        player.addEffect(new MobEffectInstance(IcariaMobEffects.BLINDNESS_IMMUNITY, 600));
                        player.awardStat(Stats.ITEM_USED.get((Object)totem));
                        CommonGameEvents.sendPacket(totem, player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickItem pEvent) {
        Player player = pEvent.getEntity();
        ItemStack mainHandItem = player.getMainHandItem();
        ItemStack offhandItem = player.getOffhandItem();
        TotemItem totem = IcariaItems.TOTEM_OF_UNSHATTERING.get();
        if (mainHandItem.getItem().equals((Object)totem)) {
            if ((float)offhandItem.getDamageValue() >= (float)offhandItem.getMaxDamage() * 0.9f && (offhandItem.getItem() instanceof BidentItem || offhandItem.getItem() instanceof BowItem || offhandItem.getItem() instanceof CrossbowItem || offhandItem.getItem() instanceof FishingRodItem || offhandItem.getItem() instanceof ShieldItem || offhandItem.getItem() instanceof TridentItem)) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                offhandItem.setDamageValue((int)((float)offhandItem.getItem().getMaxDamage(offhandItem) * 0.1f));
                player.awardStat(Stats.ITEM_USED.get((Object)totem));
                CommonGameEvents.sendPacket(totem, player);
            }
        } else if (offhandItem.getItem().equals((Object)totem) && (float)mainHandItem.getDamageValue() >= (float)mainHandItem.getMaxDamage() * 0.9f && (mainHandItem.getItem() instanceof BidentItem || mainHandItem.getItem() instanceof BowItem || mainHandItem.getItem() instanceof CrossbowItem || mainHandItem.getItem() instanceof FishingRodItem || mainHandItem.getItem() instanceof ShieldItem || mainHandItem.getItem() instanceof TridentItem)) {
            mainHandItem.setDamageValue((int)((float)mainHandItem.getItem().getMaxDamage(mainHandItem) * 0.1f));
            offhandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            player.awardStat(Stats.ITEM_USED.get((Object)totem));
            CommonGameEvents.sendPacket(totem, player);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract pEvent) {
        Player player = pEvent.getEntity();
        ItemStack mainHandItem = player.getMainHandItem();
        ItemStack offhandItem = player.getOffhandItem();
        TotemItem totem = IcariaItems.TOTEM_OF_UNSHATTERING.get();
        if (mainHandItem.getItem().equals((Object)totem)) {
            if ((float)offhandItem.getDamageValue() >= (float)offhandItem.getMaxDamage() * 0.9f && offhandItem.getItem() instanceof ShearsItem) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                offhandItem.setDamageValue((int)((float)offhandItem.getItem().getMaxDamage(offhandItem) * 0.1f));
                player.awardStat(Stats.ITEM_USED.get((Object)totem));
                CommonGameEvents.sendPacket(totem, player);
            }
        } else if (offhandItem.getItem().equals((Object)totem) && (float)mainHandItem.getDamageValue() >= (float)mainHandItem.getMaxDamage() * 0.9f && mainHandItem.getItem() instanceof ShearsItem) {
            mainHandItem.setDamageValue((int)((float)mainHandItem.getItem().getMaxDamage(mainHandItem) * 0.1f));
            offhandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            player.awardStat(Stats.ITEM_USED.get((Object)totem));
            CommonGameEvents.sendPacket(totem, player);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock pEvent) {
        Player player = pEvent.getEntity();
        ItemStack mainHandItem = player.getMainHandItem();
        ItemStack offhandItem = player.getOffhandItem();
        TotemItem totem = IcariaItems.TOTEM_OF_UNSHATTERING.get();
        if (mainHandItem.getItem().equals((Object)totem)) {
            if ((float)offhandItem.getDamageValue() >= (float)offhandItem.getMaxDamage() * 0.9f && (offhandItem.getItem() instanceof ShearsItem || offhandItem.getItem() instanceof TieredItem)) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                offhandItem.setDamageValue((int)((float)offhandItem.getItem().getMaxDamage(offhandItem) * 0.1f));
                player.awardStat(Stats.ITEM_USED.get((Object)totem));
                CommonGameEvents.sendPacket(totem, player);
            }
        } else if (offhandItem.getItem().equals((Object)totem) && (float)mainHandItem.getDamageValue() >= (float)mainHandItem.getMaxDamage() * 0.9f && (mainHandItem.getItem() instanceof ShearsItem || mainHandItem.getItem() instanceof TieredItem)) {
            mainHandItem.setDamageValue((int)((float)mainHandItem.getItem().getMaxDamage(mainHandItem) * 0.1f));
            offhandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            player.awardStat(Stats.ITEM_USED.get((Object)totem));
            CommonGameEvents.sendPacket(totem, player);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock pEvent) {
        Player player = pEvent.getEntity();
        ItemStack mainHandItem = player.getMainHandItem();
        ItemStack offhandItem = player.getOffhandItem();
        TotemItem totem = IcariaItems.TOTEM_OF_UNSHATTERING.get();
        if (mainHandItem.getItem().equals((Object)totem)) {
            if ((float)offhandItem.getDamageValue() >= (float)offhandItem.getMaxDamage() * 0.9f && (offhandItem.getItem() instanceof AxeItem || offhandItem.getItem() instanceof FlintAndSteelItem || offhandItem.getItem() instanceof HoeItem || offhandItem.getItem() instanceof ShovelItem)) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                offhandItem.setDamageValue((int)((float)offhandItem.getItem().getMaxDamage(offhandItem) * 0.1f));
                player.awardStat(Stats.ITEM_USED.get((Object)totem));
                CommonGameEvents.sendPacket(totem, player);
            }
        } else if (offhandItem.getItem().equals((Object)totem) && (float)mainHandItem.getDamageValue() >= (float)mainHandItem.getMaxDamage() * 0.9f && (mainHandItem.getItem() instanceof AxeItem || mainHandItem.getItem() instanceof FlintAndSteelItem || mainHandItem.getItem() instanceof HoeItem || mainHandItem.getItem() instanceof ShovelItem)) {
            mainHandItem.setDamageValue((int)((float)mainHandItem.getItem().getMaxDamage(mainHandItem) * 0.1f));
            offhandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            player.awardStat(Stats.ITEM_USED.get((Object)totem));
            CommonGameEvents.sendPacket(totem, player);
        }
    }

    @SubscribeEvent
    public static void onRegisterBrewingRecipes(RegisterBrewingRecipesEvent pEvent) {
        pEvent.getBuilder().addMix(Potions.AWKWARD, IcariaItems.BLINDWEED.get(), IcariaPotions.BLINDNESS);
        pEvent.getBuilder().addMix(Potions.AWKWARD, IcariaItems.SNULL_CREAM.get(), IcariaPotions.NAUSEA);
        pEvent.getBuilder().addMix(Potions.AWKWARD, Items.WITHER_ROSE, IcariaPotions.WITHER);
    }

    public static void sendPacket(Item pItem, Player pPlayer) {
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new TotemPacket(new ItemStack((ItemLike)pItem), (Holder<SoundEvent>)Holder.direct((Object)SoundEvents.TOTEM_USE)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

