/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.goal;

import com.axanthic.icaria.common.entity.CaptainRevenantEntity;
import com.axanthic.icaria.common.entity.CrawlerRevenantEntity;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import com.axanthic.icaria.common.util.IcariaSummonSpellTypes;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CaptainRevenantSummonGoal
extends Goal {
    public CaptainRevenantEntity entity;

    public CaptainRevenantSummonGoal(CaptainRevenantEntity pEntity) {
        this.entity = pEntity;
    }

    public boolean canUse() {
        return !this.entity.onUnequips() && this.entity.onRallying() && this.entity.onReequips() && this.entity.getLastHurtByPlayerTime() > 0 && this.entity.level().getNearbyEntities(CrawlerRevenantEntity.class, this.entity.targetingConditions, (LivingEntity)this.entity, this.entity.getBoundingBox().inflate(16.0)).size() <= 2;
    }

    public void start() {
        this.entity.playSound(IcariaSoundEvents.CAPTAIN_REVENANT_RALLY);
        this.entity.setCasting(IcariaSummonSpellTypes.SUMMON);
    }

    public void tick() {
        for (int i = 0; i < this.entity.getRandom().nextIntBetweenInclusive(6, 8); ++i) {
            Level level = this.entity.level();
            CrawlerRevenantEntity entity = (CrawlerRevenantEntity)IcariaEntityTypes.CRAWLER_REVENANT.get().create(level);
            BlockPos blockPos = this.entity.blockPosition().offset(-8 + this.entity.getRandom().nextInt(16), 0, -8 + this.entity.getRandom().nextInt(16));
            if (entity == null || !level.getBlockState(blockPos).canBeReplaced() || !level.getBlockState(blockPos.below()).is(IcariaBlockTags.DIRT_AND_SAND)) continue;
            entity.moveTo(blockPos, 0.0f, 0.0f);
            level.addFreshEntity((Entity)entity);
        }
    }
}

