/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.goal;

import com.axanthic.icaria.common.entity.ForestHagEntity;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.EventHooks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ForestHagPlaceSaplingGoal
extends Goal {
    public ForestHagEntity entity;

    public ForestHagPlaceSaplingGoal(ForestHagEntity pEntity) {
        this.entity = pEntity;
    }

    public boolean canUse() {
        return this.entity.getRandom().nextInt(Goal.reducedTickDelay((int)5000)) == 0 && !this.entity.isAggressive() && EventHooks.canEntityGrief((Level)this.entity.level(), (Entity)this.entity);
    }

    public void tick() {
        BlockPos blockPos = this.entity.blockPosition();
        Level level = this.entity.level();
        EntityType type = this.entity.getType();
        Block block = IcariaBlocks.CYPRESS_SAPLING.get();
        if (type == IcariaEntityTypes.DROUGHTROOT_FOREST_HAG.get()) {
            block = IcariaBlocks.DROUGHTROOT_SAPLING.get();
        } else if (type == IcariaEntityTypes.FIR_FOREST_HAG.get()) {
            block = IcariaBlocks.FIR_SAPLING.get();
        } else if (type == IcariaEntityTypes.LAUREL_FOREST_HAG.get()) {
            block = IcariaBlocks.LAUREL_SAPLING.get();
        } else if (type == IcariaEntityTypes.OLIVE_FOREST_HAG.get()) {
            block = IcariaBlocks.OLIVE_SAPLING.get();
        } else if (type == IcariaEntityTypes.PLANE_FOREST_HAG.get()) {
            block = IcariaBlocks.PLANE_SAPLING.get();
        } else if (type == IcariaEntityTypes.POPULUS_FOREST_HAG.get()) {
            block = IcariaBlocks.POPULUS_SAPLING.get();
        }
        if (level.getBlockState(blockPos).isAir() && block.defaultBlockState().canSurvive((LevelReader)level, blockPos.below())) {
            level.playSound(null, blockPos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS);
            level.setBlockAndUpdate(blockPos, block.defaultBlockState());
        }
    }
}

