/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.goal;

import com.axanthic.icaria.common.entity.IcariaAnimalEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaBreedGoal
extends Goal {
    public double speedModifier;
    public int loveTime;
    public Class<? extends IcariaAnimalEntity> partnerClass;
    public IcariaAnimalEntity entity;
    public IcariaAnimalEntity partner;
    public Level level;
    public TargetingConditions targetingConditions = TargetingConditions.forNonCombat().range(8.0);

    public IcariaBreedGoal(IcariaAnimalEntity pEntity, double pSpeedModifier) {
        this(pEntity, pSpeedModifier, pEntity.getClass());
    }

    public IcariaBreedGoal(IcariaAnimalEntity pEntity, double pSpeedModifier, Class<? extends IcariaAnimalEntity> pPartnerClass) {
        this.entity = pEntity;
        this.level = pEntity.level();
        this.partnerClass = pPartnerClass;
        this.speedModifier = pSpeedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canContinueToUse() {
        return this.partner.isAlive() && this.partner.inLove() && this.loveTime < 60;
    }

    public boolean canUse() {
        if (this.entity.inLove()) {
            this.partner = this.getFreePartner();
            return this.partner != null;
        }
        return false;
    }

    public void breed() {
        this.entity.spawnChildFromBreeding((ServerLevel)this.level, this.partner);
    }

    public void stop() {
        this.partner = null;
        this.loveTime = 0;
    }

    public void tick() {
        this.entity.getLookControl().setLookAt((Entity)this.partner, 10.0f, (float)this.entity.getMaxHeadXRot());
        this.entity.getNavigation().moveTo((Entity)this.partner, this.speedModifier);
        ++this.loveTime;
        if (this.loveTime >= 60 && this.entity.distanceToSqr((Entity)this.partner) <= 8.0) {
            this.breed();
        }
    }

    @Nullable
    public IcariaAnimalEntity getFreePartner() {
        double d = Double.MAX_VALUE;
        IcariaAnimalEntity entity = null;
        for (IcariaAnimalEntity partner : this.level.getNearbyEntities(this.partnerClass, this.targetingConditions, (LivingEntity)this.entity, this.entity.getBoundingBox().inflate(8.0))) {
            if (!this.entity.canMate(partner) || !(this.entity.distanceToSqr((Entity)partner) < d)) continue;
            entity = partner;
            d = this.entity.distanceToSqr((Entity)partner);
        }
        return entity;
    }
}

