/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.goal;

import com.axanthic.icaria.common.entity.IcariaAnimalEntity;
import com.axanthic.icaria.common.properties.Trough;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import java.util.EnumSet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.EventHooks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaEatGoal
extends Goal {
    public int eatAnimationTick;
    public IcariaAnimalEntity entity;
    public Level level;
    public Trough trough;

    public IcariaEatGoal(IcariaAnimalEntity pEntity, Trough pTrough) {
        this.entity = pEntity;
        this.level = pEntity.level();
        this.trough = pTrough;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canContinueToUse() {
        return this.eatAnimationTick > 0;
    }

    public boolean canUse() {
        Direction direction;
        BlockPos blockPos = this.entity.blockPosition();
        boolean checkTrough = this.level.getBlockState(blockPos.relative(direction = this.entity.getDirection())).is(IcariaBlockTags.TROUGHS) && this.level.getBlockState(blockPos.relative(direction)).getValue(IcariaBlockStateProperties.TROUGH) == this.trough && (Integer)this.level.getBlockState(blockPos.relative(direction)).getValue((Property)IcariaBlockStateProperties.TROUGH_FILL) > 0;
        boolean checkBlocks = this.level.getBlockState(blockPos.below()).is(IcariaBlocks.GRASSY_MARL.get()) || this.level.getBlockState(blockPos).is(IcariaBlockTags.GRASS_BLOCKS) || checkTrough;
        return this.entity.getRandom().nextInt(this.entity.isBaby() ? 50 : 1000) == 0 && checkBlocks;
    }

    public int getEatAnimationTick() {
        return this.eatAnimationTick;
    }

    public void start() {
        this.eatAnimationTick = this.adjustedTickDelay(40);
        this.level.broadcastEntityEvent((Entity)this.entity, (byte)10);
        this.entity.getNavigation().stop();
    }

    public void stop() {
        this.eatAnimationTick = 0;
    }

    public void tick() {
        this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        BlockPos blockPos = this.entity.blockPosition();
        Direction direction = this.entity.getDirection();
        if (EventHooks.canEntityGrief((Level)this.level, (Entity)this.entity) && this.eatAnimationTick == this.adjustedTickDelay(4)) {
            if (this.level.getBlockState(blockPos).is(IcariaBlockTags.GRASS_BLOCKS)) {
                this.entity.ate();
                this.level.destroyBlock(blockPos, false);
            } else if (this.level.getBlockState(blockPos.below()).is(IcariaBlocks.GRASSY_MARL.get())) {
                this.entity.ate();
                this.level.levelEvent(2001, blockPos.below(), Block.getId((BlockState)IcariaBlocks.MARL.get().defaultBlockState()));
                this.level.setBlockAndUpdate(blockPos.below(), IcariaBlocks.MARL.get().defaultBlockState());
            } else if (this.level.getBlockState(blockPos.relative(direction)).is(IcariaBlockTags.TROUGHS) && this.level.getBlockState(blockPos.relative(direction)).getValue(IcariaBlockStateProperties.TROUGH) == this.trough) {
                if ((Integer)this.level.getBlockState(blockPos.relative(direction)).getValue((Property)IcariaBlockStateProperties.TROUGH_FILL) > 1) {
                    this.entity.ate();
                    this.level.playSound(null, blockPos.relative(direction), IcariaSoundEvents.TROUGH_EMPTY, SoundSource.BLOCKS);
                    this.level.setBlockAndUpdate(blockPos.relative(direction), (BlockState)((BlockState)this.level.getBlockState(blockPos.relative(direction)).setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)this.trough))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf((Integer)this.level.getBlockState(blockPos.relative(direction)).getValue((Property)IcariaBlockStateProperties.TROUGH_FILL) - 1)));
                } else if ((Integer)this.level.getBlockState(blockPos.relative(direction)).getValue((Property)IcariaBlockStateProperties.TROUGH_FILL) > 0) {
                    this.entity.ate();
                    this.level.playSound(null, blockPos.relative(direction), IcariaSoundEvents.TROUGH_EMPTY, SoundSource.BLOCKS);
                    this.level.setBlockAndUpdate(blockPos.relative(direction), (BlockState)((BlockState)this.level.getBlockState(blockPos.relative(direction)).setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.NONE))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf((Integer)this.level.getBlockState(blockPos.relative(direction)).getValue((Property)IcariaBlockStateProperties.TROUGH_FILL) - 1)));
                }
            }
        }
    }
}

