/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.goal;

import com.axanthic.icaria.common.entity.IcariaAnimalEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaFollowParentGoal
extends Goal {
    public double speedModifier;
    public int timeToRecalcPath;
    public IcariaAnimalEntity entity;
    public IcariaAnimalEntity parent;

    public IcariaFollowParentGoal(IcariaAnimalEntity pEntity, double pSpeedModifier) {
        this.entity = pEntity;
        this.speedModifier = pSpeedModifier;
    }

    public boolean canContinueToUse() {
        if (!this.entity.isBaby()) {
            return false;
        }
        if (!this.parent.isAlive()) {
            return false;
        }
        double d = this.entity.distanceToSqr((Entity)this.parent);
        return !(d <= 8.0) && !(d >= 256.0);
    }

    public boolean canUse() {
        if (!this.entity.isBaby()) {
            return false;
        }
        double d0 = Double.MAX_VALUE;
        IcariaAnimalEntity entity = null;
        for (IcariaAnimalEntity parent : this.entity.level().getEntitiesOfClass(this.entity.getClass(), this.entity.getBoundingBox().inflate(8.0, 4.0, 8.0))) {
            double d1;
            if (parent.isBaby() || (d1 = this.entity.distanceToSqr((Entity)parent)) > d0) continue;
            d0 = d1;
            entity = parent;
        }
        if (entity == null) {
            return false;
        }
        if (d0 <= 8.0) {
            return false;
        }
        this.parent = entity;
        return true;
    }

    public void start() {
        this.timeToRecalcPath = 0;
    }

    public void stop() {
        this.parent = null;
    }

    public void tick() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            this.entity.getNavigation().moveTo((Entity)this.parent, this.speedModifier);
        }
    }
}

