/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaPanicGoal
extends Goal {
    public boolean isRunning;
    public double posX;
    public double posY;
    public double posZ;
    public double speedModifier;
    public PathfinderMob mob;

    public IcariaPanicGoal(PathfinderMob pMob, double pSpeedModifier) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    public boolean canUse() {
        BlockPos blockPos;
        if (!this.shouldPanic()) {
            return false;
        }
        if (this.mob.isOnFire() && (blockPos = this.lookForWater((BlockGetter)this.mob.level(), (Entity)this.mob, 5)) != null) {
            this.posX = blockPos.getX();
            this.posY = blockPos.getY();
            this.posZ = blockPos.getZ();
            return true;
        }
        return this.findRandomPosition();
    }

    public boolean findRandomPosition() {
        Vec3 vec3 = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)5, (int)4);
        if (vec3 == null) {
            return false;
        }
        this.posX = vec3.x;
        this.posY = vec3.y;
        this.posZ = vec3.z;
        return true;
    }

    public boolean shouldPanic() {
        return this.mob.isOnFire();
    }

    public void start() {
        this.isRunning = true;
        this.mob.getNavigation().moveTo(this.posX, this.posY, this.posZ, this.speedModifier);
    }

    public void stop() {
        this.isRunning = false;
    }

    @Nullable
    public BlockPos lookForWater(BlockGetter pLevel, Entity pEntity, int pRange) {
        return BlockPos.findClosestMatch((BlockPos)pEntity.blockPosition(), (int)pRange, (int)1, pBlockPos -> pLevel.getFluidState(pBlockPos).is(FluidTags.WATER)).orElse(null);
    }
}

