/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.goal;

import com.axanthic.icaria.common.entity.JellyfishEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class JellyfishFleeGoal
extends Goal {
    public int fleeTicks;
    public JellyfishEntity entity;

    public JellyfishFleeGoal(JellyfishEntity pEntity) {
        this.entity = pEntity;
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.entity.getLastHurtByMob();
        if (livingEntity != null) {
            return this.entity.distanceToSqr((Entity)livingEntity) < 100.0;
        }
        return false;
    }

    public void start() {
        this.fleeTicks = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        ++this.fleeTicks;
        LivingEntity livingEntity = this.entity.getLastHurtByMob();
        if (livingEntity != null) {
            Vec3 vec3 = new Vec3(this.entity.getX() - livingEntity.getX(), this.entity.getY() - livingEntity.getY(), this.entity.getZ() - livingEntity.getZ());
            if (this.entity.level().getBlockState(BlockPos.containing((double)(this.entity.getX() + vec3.x), (double)(this.entity.getY() + vec3.y), (double)(this.entity.getZ() + vec3.z))).isAir()) {
                double length = vec3.length();
                if (length > 0.0) {
                    vec3.normalize();
                    double d = 3.0;
                    if (length > 5.0) {
                        d -= (length - 5.0) / 5.0;
                    }
                    if (d > 0.0) {
                        vec3 = vec3.scale(d);
                    }
                }
                this.entity.setMovementVector((float)vec3.x / 20.0f, (float)vec3.y / 20.0f, (float)vec3.z / 20.0f);
            }
        }
    }
}

