/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.goal;

import com.axanthic.icaria.common.entity.MyrmekeQueenEntity;
import com.axanthic.icaria.common.entity.MyrmekeSoldierEntity;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.util.IcariaSummonSpellTypes;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MyrmekeQueenSummonGoal
extends Goal {
    public MyrmekeQueenEntity entity;
    public TargetingConditions targetingConditions = TargetingConditions.forNonCombat().range(16.0);

    public MyrmekeQueenSummonGoal(MyrmekeQueenEntity pEntity) {
        this.entity = pEntity;
    }

    public boolean canUse() {
        return this.entity.level().getNearbyEntities(MyrmekeSoldierEntity.class, this.targetingConditions, (LivingEntity)this.entity, this.entity.getBoundingBox().inflate(32.0)).size() <= 2;
    }

    public void start() {
        this.entity.setCasting(IcariaSummonSpellTypes.SUMMON);
    }

    public void tick() {
        for (int i = 0; i < this.entity.getRandom().nextIntBetweenInclusive(3, 4); ++i) {
            Level level = this.entity.level();
            MyrmekeSoldierEntity entity = (MyrmekeSoldierEntity)IcariaEntityTypes.MYRMEKE_SOLDIER.get().create(level);
            BlockPos blockPos = this.entity.blockPosition().offset(-4 + this.entity.getRandom().nextInt(8), 0, -4 + this.entity.getRandom().nextInt(8));
            if (entity == null || !level.getBlockState(blockPos).canBeReplaced() || !this.entity.getBlockStateOn().is(IcariaBlockTags.DIRT_AND_SAND)) continue;
            entity.moveTo(blockPos, 0.0f, 0.0f);
            level.addFreshEntity((Entity)entity);
        }
    }
}

