/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.handler.item;

import com.axanthic.icaria.common.entity.KilnBlockEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class KilnOutputSlotItemHandler
extends SlotItemHandler {
    public int removeCount;
    public KilnBlockEntity blockEntity;
    public Player player;

    public KilnOutputSlotItemHandler(IItemHandler pHandler, KilnBlockEntity pBlockEntity, Player pPlayer, int pIndex, int pX, int pY) {
        super(pHandler, pIndex, pX, pY);
        this.blockEntity = pBlockEntity;
        this.player = pPlayer;
    }

    public void checkTakeAchievements(ItemStack pStack) {
        pStack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.blockEntity.awardUsedRecipesAndPopExperience(serverPlayer);
        }
        this.removeCount = 0;
    }

    public void onQuickCraft(ItemStack pStack, int pAmount) {
        this.removeCount += pAmount;
        this.checkTakeAchievements(pStack);
    }

    public void onTake(Player pPlayer, ItemStack pStack) {
        this.checkTakeAchievements(pStack);
        super.onTake(pPlayer, pStack);
    }

    public ItemStack remove(int pAmount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(pAmount, this.getItem().getCount());
        }
        return super.remove(pAmount);
    }
}

