/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.item;

import com.axanthic.icaria.common.entity.BidentEntity;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.SimpleTier;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BidentItem
extends TieredItem {
    public BidentItem(SimpleTier pTier, Item.Properties pProperties) {
        super((Tier)pTier, pProperties);
    }

    public boolean canAttackBlock(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return !pPlayer.isCreative();
    }

    public boolean hurtEnemy(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.hurtAndBreak(1, pAttacker, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        return true;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pLivingEntity) {
        return 72000;
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (this.getUseDuration(pStack, pLivingEntity) - pTimeCharged >= 10) {
                player.playSound(IcariaSoundEvents.BIDENT_THROW);
                if (!pLevel.isClientSide()) {
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    pStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)pLivingEntity.getUsedItemHand()));
                    BidentEntity entity = new BidentEntity(pLevel, (LivingEntity)player, pStack);
                    entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 1.0f);
                    pLevel.addFreshEntity((Entity)entity);
                    if (player.getAbilities().instabuild) {
                        entity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else {
                        player.getInventory().removeItem(pStack);
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        pPlayer.startUsingItem(pUsedHand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public static ItemAttributeModifiers createAttributes(SimpleTier pTier, float pAttackDamage, float pAttackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(pAttackDamage + pTier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)pAttackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.SPEAR;
    }
}

