/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.item;

import com.axanthic.icaria.common.entity.BubbleSpellEntity;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BubbleSpellItem
extends Item {
    public BubbleSpellItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public EntityType<?> getEntity() {
        return IcariaEntityTypes.BUBBLE_SPELL.get();
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        pPlayer.playSound(IcariaSoundEvents.BUBBLE_SPELL_SHOOT);
        if (!pLevel.isClientSide()) {
            for (int i = 0; i < pLevel.getRandom().nextInt(4) + 4; ++i) {
                Entity entity = this.getEntity().create(pLevel);
                if (!(entity instanceof BubbleSpellEntity)) continue;
                BubbleSpellEntity spellEntity = (BubbleSpellEntity)entity;
                spellEntity.moveTo(pPlayer.getX(), pPlayer.getY() + (double)pPlayer.getEyeHeight(), pPlayer.getZ());
                spellEntity.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), 0.0f, 0.1f, 20.0f);
                pLevel.addFreshEntity((Entity)spellEntity);
            }
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!pPlayer.isCreative()) {
                itemStack.shrink(1);
                pPlayer.getCooldowns().addCooldown(itemStack.getItem(), 40);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)pLevel.isClientSide());
    }
}

