/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.item;

import com.axanthic.icaria.client.screen.ChestLabelScreen;
import com.axanthic.icaria.common.registry.IcariaDataComponents;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ChestLabelItem
extends Item {
    public ChestLabelItem(Item.Properties pProperties) {
        super(pProperties.component(IcariaDataComponents.COLOR, (Object)0).component(IcariaDataComponents.LABEL, (Object)"").component(IcariaDataComponents.STYLE, (Object)false));
    }

    public int getColorByColor(int pColor) {
        return pColor == 0 ? 0xFFFFFF : pColor;
    }

    public int getColorByStyle(boolean pStyle) {
        return pStyle ? 0xFFFF55 : 0x5555FF;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pList, TooltipFlag pFlag) {
        Integer color = (Integer)pStack.getOrDefault(IcariaDataComponents.COLOR, (Object)0);
        String label = (String)pStack.getOrDefault(IcariaDataComponents.LABEL, (Object)"");
        Boolean style = (Boolean)pStack.getOrDefault(IcariaDataComponents.STYLE, (Object)false);
        pList.add((Component)Component.translatable((String)this.getLabelByLabel(label)).withStyle(ChatFormatting.GRAY));
        pList.add(CommonComponents.EMPTY);
        pList.add((Component)Component.translatable((String)"tooltip.landsoficaria.chest_label.color").withStyle(ChatFormatting.GRAY));
        pList.add((Component)Component.translatable((String)this.getNameByColor(color)).withColor(this.getColorByColor(color)));
        pList.add((Component)Component.translatable((String)"tooltip.landsoficaria.chest_label.style").withStyle(ChatFormatting.GRAY));
        pList.add((Component)Component.translatable((String)this.getNameByStyle(style)).withColor(this.getColorByStyle(style)));
    }

    public String getLabelByLabel(String pLabel) {
        return pLabel.isEmpty() ? "tooltip.landsoficaria.chest_label.title" : pLabel;
    }

    public String getNameByColor(int pColor) {
        return switch (pColor) {
            case 0xFFFFFF -> "tooltip.landsoficaria.chest_label.white";
            case 0xD3D3D3 -> "tooltip.landsoficaria.chest_label.light_gray";
            case 0x808080 -> "tooltip.landsoficaria.chest_label.gray";
            case 0 -> "tooltip.landsoficaria.chest_label.black";
            case 9127187 -> "tooltip.landsoficaria.chest_label.brown";
            case 0xFF0000 -> "tooltip.landsoficaria.chest_label.red";
            case 16738335 -> "tooltip.landsoficaria.chest_label.orange";
            case 0xFFFF00 -> "tooltip.landsoficaria.chest_label.yellow";
            case 0xBFFF00 -> "tooltip.landsoficaria.chest_label.lime";
            case 65280 -> "tooltip.landsoficaria.chest_label.green";
            case 65535 -> "tooltip.landsoficaria.chest_label.cyan";
            case 10141901 -> "tooltip.landsoficaria.chest_label.light_blue";
            case 255 -> "tooltip.landsoficaria.chest_label.blue";
            case 10494192 -> "tooltip.landsoficaria.chest_label.purple";
            case 0xFF00FF -> "tooltip.landsoficaria.chest_label.magenta";
            case 16738740 -> "tooltip.landsoficaria.chest_label.pink";
            default -> throw new IllegalStateException("Unexpected value: " + pColor);
        };
    }

    public String getNameByStyle(boolean pStyle) {
        return pStyle ? "tooltip.landsoficaria.chest_label.glowing" : "tooltip.landsoficaria.chest_label.classic";
    }

    @OnlyIn(value=Dist.CLIENT)
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (pPlayer instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)pPlayer;
            if (pUsedHand.equals((Object)InteractionHand.MAIN_HAND)) {
                Minecraft.getInstance().setScreen((Screen)new ChestLabelScreen(stack));
                localPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)pLevel.isClientSide());
    }
}

