/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.item;

import com.axanthic.icaria.common.registry.IcariaItems;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcoctionFlaskItem
extends Item {
    public int duration;
    public Holder<MobEffect> effect;

    public ConcoctionFlaskItem(Item.Properties pProperties, Holder<MobEffect> pEffect, int pDuration) {
        super(pProperties);
        this.duration = pDuration;
        this.effect = pEffect;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pLivingEntity) {
        return 32;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        pPlayer.startUsingItem(pHand);
        return InteractionResultHolder.consume((Object)pPlayer.getItemInHand(pHand));
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        MobEffectInstance effect = new MobEffectInstance(this.effect, this.duration);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            player.addEffect(effect);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (player.isCreative()) {
                return pStack;
            }
        }
        return new ItemStack((ItemLike)IcariaItems.EMPTY_FLASK.get());
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.DRINK;
    }
}

