/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.item;

import com.axanthic.icaria.common.entity.GreekFireGrenadeEntity;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GreekFireGrenadeItem
extends Item {
    public GreekFireGrenadeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pLivingEntity) {
        return 72000;
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (this.getUseDuration(pStack, pLivingEntity) - pTimeCharged >= 10) {
                player.playSound(IcariaSoundEvents.GREEK_FIRE_GRENADE_THROW);
                if (!pLevel.isClientSide()) {
                    GreekFireGrenadeEntity entity = new GreekFireGrenadeEntity(pLevel, (LivingEntity)player, pStack);
                    entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 1.0f);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    pLevel.addFreshEntity((Entity)entity);
                    if (!player.isCreative()) {
                        pStack.shrink(1);
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        pPlayer.startUsingItem(pUsedHand);
        return InteractionResultHolder.consume((Object)pPlayer.getItemInHand(pUsedHand));
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.SPEAR;
    }
}

