/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.item;

import com.axanthic.icaria.common.entity.IcariaPaintingEntity;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaPaintingItem
extends HangingEntityItem {
    public IcariaPaintingItem(Item.Properties pProperties) {
        super(IcariaEntityTypes.PAINTING.get(), pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Direction direction = pContext.getClickedFace();
        ItemStack itemStack = pContext.getItemInHand();
        Level level = pContext.getLevel();
        Player player = pContext.getPlayer();
        BlockPos blockPos = pContext.getClickedPos().relative(direction);
        if (player != null && !this.mayPlace(player, direction, itemStack, blockPos)) {
            return InteractionResult.FAIL;
        }
        Optional<Painting> optional = IcariaPaintingEntity.create(level, blockPos, direction);
        if (optional.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        Painting painting = optional.get();
        if (painting.survives() && !level.isClientSide()) {
            itemStack.shrink(1);
            level.addFreshEntity((Entity)painting);
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, painting.position());
            painting.playPlacementSound();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }
}

