/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.item;

import com.axanthic.icaria.data.tags.IcariaBlockTags;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.SimpleTier;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ScytheItem
extends HoeItem {
    public static final Set<ItemAbility> SCYTHE_ACTIONS = Stream.of(ItemAbilities.HOE_TILL, ItemAbilities.SWORD_SWEEP).collect(Collectors.toCollection(Sets::newIdentityHashSet));

    public ScytheItem(SimpleTier pTier, Item.Properties pProperties) {
        super((Tier)pTier, pProperties);
    }

    public boolean canPerformAction(ItemStack pStack, ItemAbility pAction) {
        return SCYTHE_ACTIONS.contains(pAction);
    }

    public boolean hurtEnemy(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.hurtAndBreak(1, pAttacker, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack pStack, BlockState pState) {
        return pState.is(IcariaBlockTags.MINEABLE_WITH_SCYTHE);
    }

    public AABB getSweepHitBox(ItemStack pStack, Player pPlayer, Entity pTarget) {
        return pTarget.getBoundingBox().inflate(1.4, 0.25, 1.4);
    }
}

