/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.item;

import com.axanthic.icaria.common.entity.SpellEntity;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpellItem
extends Item {
    public float inaccuracy;
    public float velocity;
    public int color;
    public int cooldown;

    public SpellItem(Item.Properties pProperties, float pInaccuracy, float pVelocity, int pColor, int pCooldown) {
        super(pProperties);
        this.inaccuracy = pInaccuracy;
        this.velocity = pVelocity;
        this.color = pColor;
        this.cooldown = pCooldown;
    }

    @Nullable
    public EntityType<?> getEntity() {
        return null;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        Entity entity;
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        pPlayer.playSound(IcariaSoundEvents.SPELL_SHOOT);
        if (!pLevel.isClientSide() && this.getEntity() != null && (entity = this.getEntity().create(pLevel)) instanceof SpellEntity) {
            SpellEntity spellEntity = (SpellEntity)entity;
            spellEntity.moveTo(pPlayer.getX(), pPlayer.getY() + (double)pPlayer.getEyeHeight(), pPlayer.getZ());
            spellEntity.setColor(this.color);
            spellEntity.setOwner((Entity)pPlayer);
            spellEntity.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), 0.0f, this.velocity, this.inaccuracy);
            pLevel.addFreshEntity((Entity)spellEntity);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!pPlayer.isCreative()) {
                itemStack.shrink(1);
                pPlayer.getCooldowns().addCooldown(itemStack.getItem(), this.cooldown);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)pLevel.isClientSide());
    }
}

