/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.item;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VineSproutItem
extends Item {
    public VineSproutItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean isEnchantable(ItemStack pStack) {
        return false;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pLivingEntity) {
        return 16;
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        ItemStack stack = new ItemStack((ItemLike)this);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            player.eat(pLevel, stack);
            if (!pLevel.isClientSide()) {
                player.getCooldowns().addCooldown((Item)this, 400);
                if (!player.isCreative()) {
                    pStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                }
            }
        }
        return pStack;
    }

    public SoundEvent getBreakingSound() {
        return SoundEvents.EMPTY;
    }
}

