/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.menu;

import com.axanthic.icaria.common.entity.GrinderBlockEntity;
import com.axanthic.icaria.common.handler.item.GrinderOutputSlotItemHandler;
import com.axanthic.icaria.common.registry.IcariaMenus;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GrinderMenu
extends AbstractContainerMenu {
    public GrinderBlockEntity blockEntity;
    public ContainerData containerData;

    public GrinderMenu(int pContainerId, BlockPos pPos, Inventory pInventory, Player pPlayer) {
        super(IcariaMenus.GRINDER.get(), pContainerId);
        BlockEntity blockEntity = pPlayer.getCommandSenderWorld().getBlockEntity(pPos);
        if (blockEntity instanceof GrinderBlockEntity) {
            GrinderBlockEntity grinderBlockEntity;
            this.blockEntity = grinderBlockEntity = (GrinderBlockEntity)blockEntity;
            this.containerData = grinderBlockEntity.getData();
            this.addDataSlots(this.containerData);
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.fuelHandler, 0, 36, 58));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.gearHandler, 0, 98, 49));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inputHandler, 0, 36, 22));
            this.addSlot((Slot)new GrinderOutputSlotItemHandler((IItemHandler)this.blockEntity.outputHandler, this.blockEntity, pPlayer, 0, 124, 58));
            this.addSlot((Slot)new GrinderOutputSlotItemHandler((IItemHandler)this.blockEntity.outputHandler, this.blockEntity, pPlayer, 1, 124, 40));
            this.addSlot((Slot)new GrinderOutputSlotItemHandler((IItemHandler)this.blockEntity.outputHandler, this.blockEntity, pPlayer, 2, 124, 22));
            this.addSlots((Container)pInventory, 9, 9, 3, 8, 94);
            this.addSlots((Container)pInventory, 0, 9, 1, 8, 152);
        }
    }

    public boolean stillValid(Player pPlayer) {
        return !this.blockEntity.isRemoved();
    }

    public int getMaxFuel() {
        return this.containerData.get(0);
    }

    public int getFuel() {
        return this.containerData.get(1);
    }

    public int getMaxProgress() {
        return this.containerData.get(2);
    }

    public int getProgress() {
        return this.containerData.get(3);
    }

    public void addSlots(Container pContainer, int pStartIndex, int pCountX, int pCountY, int pStartX, int pStartY) {
        for (int x = 0; x < pCountX; ++x) {
            for (int y = 0; y < pCountY; ++y) {
                this.addSlot(new Slot(pContainer, pStartIndex + x + y * pCountX, pStartX + x * 18, pStartY + y * 18));
            }
        }
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack emptyStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack itemStack = slot.getItem();
            emptyStack = itemStack.copy();
            if (pIndex < 6) {
                this.moveItemStackTo(itemStack, 6, 42, true);
            } else {
                this.moveItemStackTo(itemStack, 0, 3, false);
            }
            if (pIndex > 5 && pIndex < 33) {
                this.moveItemStackTo(itemStack, 33, 42, true);
            } else {
                this.moveItemStackTo(itemStack, 6, 33, false);
            }
            if (itemStack.getCount() == emptyStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemStack);
        }
        return emptyStack;
    }
}

