/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.network.packet;

import com.axanthic.icaria.common.network.runnable.TotemRunnable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TotemPacket
implements CustomPacketPayload {
    public Holder<SoundEvent> sound;
    public ItemStack stack;
    public static final StreamCodec<RegistryFriendlyByteBuf, TotemPacket> STREAM_CODEC = CustomPacketPayload.codec(TotemPacket::write, TotemPacket::new);
    public static final CustomPacketPayload.Type<TotemPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"landsoficaria", (String)"totem"));

    public TotemPacket(ItemStack pStack, Holder<SoundEvent> pSound) {
        this.stack = pStack;
        this.sound = pSound;
    }

    public TotemPacket(RegistryFriendlyByteBuf pBuffer) {
        this((ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer), (Holder<SoundEvent>)((Holder)SoundEvent.STREAM_CODEC.decode((Object)pBuffer)));
    }

    public static void handler(TotemPacket pPacket, IPayloadContext pContext) {
        pContext.enqueueWork((Runnable)new TotemRunnable(pPacket, pContext));
    }

    public void write(RegistryFriendlyByteBuf pBuffer) {
        ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)this.stack);
        SoundEvent.STREAM_CODEC.encode((Object)pBuffer, this.sound);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

