/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.network.runnable;

import com.axanthic.icaria.common.network.packet.TotemPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TotemRunnable
implements Runnable {
    public IPayloadContext context;
    public TotemPacket packet;

    public TotemRunnable(TotemPacket pPacket, IPayloadContext pContext) {
        this.context = pContext;
        this.packet = pPacket;
    }

    @Override
    public void run() {
        Minecraft minecraft = Minecraft.getInstance();
        Player player = this.context.player();
        minecraft.gameRenderer.displayItemActivation(this.packet.stack);
        minecraft.particleEngine.createTrackingEmitter((Entity)player, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, 20);
        Level level = player.level();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            clientLevel.playLocalSound(player.getX(), player.getY(), player.getZ(), (SoundEvent)this.packet.sound.value(), player.getSoundSource(), 1.0f, 1.0f, false);
        }
    }
}

