/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.recipe;

import com.axanthic.icaria.common.block.KettleBlock;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaRecipeSerializers;
import com.axanthic.icaria.common.registry.IcariaRecipeTypes;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcoctingEntityRecipe
implements Recipe<RecipeInput> {
    public int burnTime;
    public int color;
    public List<Ingredient> ingredients;
    public String entity;

    public ConcoctingEntityRecipe(int pBurnTime, int pColor, List<Ingredient> pIngredients, String pEntity) {
        this.burnTime = pBurnTime;
        this.color = pColor;
        this.ingredients = pIngredients;
        this.entity = pEntity;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public boolean matches(RecipeInput pInput, Level pLevel) {
        return this.matches(pInput) && !pLevel.isClientSide();
    }

    public boolean matches(RecipeInput pInput) {
        return this.ingredients.size() < 3 ? (this.ingredients.size() < 2 ? this.matchesSingle(pInput) : this.matchesDouble(pInput)) : this.matchesTriple(pInput);
    }

    public boolean matchesSingle(RecipeInput pInput) {
        return this.ingredients.get(0).test(pInput.getItem(0)) && pInput.getItem(1).isEmpty() && pInput.getItem(2).isEmpty();
    }

    public boolean matchesDouble(RecipeInput pInput) {
        return this.ingredients.get(0).test(pInput.getItem(0)) && this.ingredients.get(1).test(pInput.getItem(1)) && pInput.getItem(2).isEmpty();
    }

    public boolean matchesTriple(RecipeInput pInput) {
        return this.ingredients.get(0).test(pInput.getItem(0)) && this.ingredients.get(1).test(pInput.getItem(1)) && this.ingredients.get(2).test(pInput.getItem(2));
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getColor() {
        return this.color;
    }

    public void performRecipe(Level pLevel, BlockPos pPos) {
        Entity entity;
        Optional optional = EntityType.byString((String)this.entity);
        if (optional.isPresent() && (entity = ((EntityType)optional.get()).create(pLevel)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            BlockState state = pLevel.getBlockState(pPos);
            Block block = state.getBlock();
            if (block instanceof KettleBlock) {
                KettleBlock kettleBlock = (KettleBlock)block;
                BlockPos blockPos = pPos.offset(pLevel.getRandom().nextInt(8) - 4, 0, pLevel.getRandom().nextInt(8) - 4);
                if (this.entity.equals(BuiltInRegistries.ENTITY_TYPE.getKey(IcariaEntityTypes.CAPTAIN_REVENANT.get()).toString())) {
                    livingEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IcariaItems.ORICHALCUM_TOOLS.sword.get()));
                    livingEntity.moveTo((double)pPos.getX() + kettleBlock.getX(state), (double)pPos.getY() + 0.75, (double)pPos.getZ() + kettleBlock.getZ(state));
                    pLevel.playSound(null, pPos, IcariaSoundEvents.KETTLE_POP, SoundSource.BLOCKS);
                    pLevel.addFreshEntity((Entity)livingEntity);
                } else if (this.entity.equals(BuiltInRegistries.ENTITY_TYPE.getKey(IcariaEntityTypes.CRAWLER_REVENANT.get()).toString()) || this.entity.equals(BuiltInRegistries.ENTITY_TYPE.getKey(IcariaEntityTypes.MYRMEKE_SOLDIER.get()).toString())) {
                    livingEntity.moveTo(blockPos, 0.0f, 0.0f);
                    pLevel.addFreshEntity((Entity)livingEntity);
                } else if (this.entity.equals(BuiltInRegistries.ENTITY_TYPE.getKey(IcariaEntityTypes.NETHER_PYROMANCER_REVENANT.get()).toString())) {
                    livingEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IcariaItems.GREEK_FIRE_GRENADE.get()));
                    livingEntity.moveTo((double)pPos.getX() + kettleBlock.getX(state), (double)pPos.getY() + 0.75, (double)pPos.getZ() + kettleBlock.getZ(state));
                    pLevel.playSound(null, pPos, IcariaSoundEvents.KETTLE_POP, SoundSource.BLOCKS);
                    pLevel.addFreshEntity((Entity)livingEntity);
                } else if (this.entity.equals(BuiltInRegistries.ENTITY_TYPE.getKey(IcariaEntityTypes.SOLDIER_REVENANT.get()).toString())) {
                    livingEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IcariaItems.KASSITEROS_TOOLS.sword.get()));
                    livingEntity.moveTo((double)pPos.getX() + kettleBlock.getX(state), (double)pPos.getY() + 0.75, (double)pPos.getZ() + kettleBlock.getZ(state));
                    pLevel.playSound(null, pPos, IcariaSoundEvents.KETTLE_POP, SoundSource.BLOCKS);
                    pLevel.addFreshEntity((Entity)livingEntity);
                } else {
                    livingEntity.moveTo((double)pPos.getX() + kettleBlock.getX(state), (double)pPos.getY() + 0.75, (double)pPos.getZ() + kettleBlock.getZ(state));
                    pLevel.playSound(null, pPos, IcariaSoundEvents.KETTLE_POP, SoundSource.BLOCKS);
                    pLevel.addFreshEntity((Entity)livingEntity);
                }
            }
        }
    }

    public ItemStack assemble(RecipeInput pInput, HolderLookup.Provider pProvider) {
        return ItemStack.EMPTY;
    }

    public ItemStack getResultItem(HolderLookup.Provider pProvider) {
        return ItemStack.EMPTY;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.addAll(this.ingredients);
        return list;
    }

    public RecipeSerializer<?> getSerializer() {
        return IcariaRecipeSerializers.CONCOCTING_ENTITY.get();
    }

    public RecipeType<?> getType() {
        return IcariaRecipeTypes.CONCOCTING_ENTITY.get();
    }
}

