/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.recipe;

import com.axanthic.icaria.common.registry.IcariaRecipeSerializers;
import com.axanthic.icaria.common.registry.IcariaRecipeTypes;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GrindingRecipe
implements Recipe<RecipeInput> {
    public float experience;
    public int burnTime;
    public Ingredient gear;
    public List<Ingredient> ingredients;
    public ItemStack output;

    public GrindingRecipe(float pExperience, int pBurnTime, Ingredient pGear, List<Ingredient> pIngredients, ItemStack pOutput) {
        this.experience = pExperience;
        this.burnTime = pBurnTime;
        this.gear = pGear;
        this.ingredients = pIngredients;
        this.output = pOutput;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public boolean matches(RecipeInput pInput, Level pLevel) {
        return !pLevel.isClientSide() && this.gear.test(pInput.getItem(0)) && this.ingredients.get(0).test(pInput.getItem(1));
    }

    public float getExperience() {
        return this.experience;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public ItemStack assemble(RecipeInput pInput, HolderLookup.Provider pProvider) {
        return this.output;
    }

    public ItemStack getResultItem(HolderLookup.Provider pProvider) {
        return this.output.copy();
    }

    public Ingredient getGear() {
        return this.gear;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.addAll(this.ingredients);
        return list;
    }

    public RecipeSerializer<?> getSerializer() {
        return IcariaRecipeSerializers.GRINDING.get();
    }

    public RecipeType<?> getType() {
        return IcariaRecipeTypes.GRINDING.get();
    }
}

