/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.recipe.builder;

import com.axanthic.icaria.common.recipe.ConcoctingExplosionsRecipe;
import com.axanthic.icaria.common.recipe.helper.IcariaRecipeHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcoctingExplosionsRecipeBuilder
implements RecipeBuilder {
    public float radius;
    public int burnTime;
    public int color;
    public RecipeCategory category;
    public Ingredient ingredientA;
    public Ingredient ingredientB;
    public Ingredient ingredientC;
    public Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public ConcoctingExplosionsRecipeBuilder(float pRadius, int pBurnTime, int pColor, Ingredient pIngredientA, Ingredient pIngredientB, Ingredient pIngredientC, RecipeCategory pCategory) {
        this.radius = pRadius;
        this.burnTime = pBurnTime;
        this.color = pColor;
        this.ingredientA = pIngredientA;
        this.ingredientB = pIngredientB;
        this.ingredientC = pIngredientC;
        this.category = pCategory;
    }

    public static ConcoctingExplosionsRecipeBuilder concoctingExplosions(RecipeCategory pCategory, Ingredient pIngredientA, Ingredient pIngredientB, Ingredient pIngredientC, float pRadius, int pBurnTime, int pColor) {
        return new ConcoctingExplosionsRecipeBuilder(pRadius, pBurnTime, pColor, pIngredientA, pIngredientB, pIngredientC, pCategory);
    }

    public void ensureValid(ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
        }
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        Advancement.Builder builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pRecipeId)).requirements(AdvancementRequirements.Strategy.OR).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pRecipeId));
        ConcoctingExplosionsRecipe recipe = new ConcoctingExplosionsRecipe(this.radius, this.burnTime, this.color, IcariaRecipeHelper.helper(this.ingredientA, this.ingredientB, this.ingredientC));
        pRecipeOutput.accept(pRecipeId, (Recipe)recipe, builder.build(pRecipeId.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    public ConcoctingExplosionsRecipeBuilder group(@Nullable String pGroupName) {
        return this;
    }

    public ConcoctingExplosionsRecipeBuilder unlockedBy(String pName, Criterion<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    public Item getResult() {
        return ItemStack.EMPTY.getItem();
    }
}

