/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.recipe.serializer;

import com.axanthic.icaria.common.recipe.ConcoctingEntityRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcoctingEntityRecipeSerializer
implements RecipeSerializer<ConcoctingEntityRecipe> {
    public static final MapCodec<ConcoctingEntityRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("burnTime").forGetter(recipe -> recipe.burnTime), (App)Codec.INT.fieldOf("color").forGetter(recipe -> recipe.color), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)Codec.STRING.fieldOf("entity").forGetter(recipe -> recipe.entity)).apply((Applicative)instance, ConcoctingEntityRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConcoctingEntityRecipe> STREAM_CODEC = StreamCodec.of(ConcoctingEntityRecipeSerializer::toNetwork, ConcoctingEntityRecipeSerializer::fromNetwork);

    public MapCodec<ConcoctingEntityRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ConcoctingEntityRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    public static ConcoctingEntityRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
        int burnTime = pBuffer.readInt();
        int color = pBuffer.readInt();
        String entity = pBuffer.readUtf();
        NonNullList ingredients = NonNullList.withSize((int)pBuffer.readInt(), (Object)Ingredient.EMPTY);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer)));
        }
        return new ConcoctingEntityRecipe(burnTime, color, (List<Ingredient>)ingredients, entity);
    }

    public static void toNetwork(RegistryFriendlyByteBuf pBuffer, ConcoctingEntityRecipe pRecipe) {
        pBuffer.writeInt(pRecipe.burnTime);
        pBuffer.writeInt(pRecipe.color);
        pBuffer.writeUtf(pRecipe.entity);
        pBuffer.writeInt(pRecipe.getIngredients().size());
        for (Ingredient ingredient : pRecipe.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)ingredient);
        }
    }
}

