/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.recipe.serializer;

import com.axanthic.icaria.common.recipe.ConcoctingExplosionsRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcoctingExplosionsRecipeSerializer
implements RecipeSerializer<ConcoctingExplosionsRecipe> {
    public static final MapCodec<ConcoctingExplosionsRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("radius").forGetter(recipe -> Float.valueOf(recipe.radius)), (App)Codec.INT.fieldOf("burnTime").forGetter(recipe -> recipe.burnTime), (App)Codec.INT.fieldOf("color").forGetter(recipe -> recipe.color), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").forGetter(recipe -> recipe.ingredients)).apply((Applicative)instance, ConcoctingExplosionsRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConcoctingExplosionsRecipe> STREAM_CODEC = StreamCodec.of(ConcoctingExplosionsRecipeSerializer::toNetwork, ConcoctingExplosionsRecipeSerializer::fromNetwork);

    public MapCodec<ConcoctingExplosionsRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ConcoctingExplosionsRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    public static ConcoctingExplosionsRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
        float radius = pBuffer.readFloat();
        int burnTime = pBuffer.readInt();
        int color = pBuffer.readInt();
        NonNullList ingredients = NonNullList.withSize((int)pBuffer.readInt(), (Object)Ingredient.EMPTY);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer)));
        }
        return new ConcoctingExplosionsRecipe(radius, burnTime, color, (List<Ingredient>)ingredients);
    }

    public static void toNetwork(RegistryFriendlyByteBuf pBuffer, ConcoctingExplosionsRecipe pRecipe) {
        pBuffer.writeFloat(pRecipe.radius);
        pBuffer.writeInt(pRecipe.burnTime);
        pBuffer.writeInt(pRecipe.color);
        pBuffer.writeInt(pRecipe.getIngredients().size());
        for (Ingredient ingredient : pRecipe.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)ingredient);
        }
    }
}

