/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.recipe.serializer;

import com.axanthic.icaria.common.recipe.ConcoctingItemRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcoctingItemRecipeSerializer
implements RecipeSerializer<ConcoctingItemRecipe> {
    public static final MapCodec<ConcoctingItemRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("burnTime").forGetter(recipe -> recipe.burnTime), (App)Codec.INT.fieldOf("color").forGetter(recipe -> recipe.color), (App)ItemStack.CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").forGetter(recipe -> recipe.ingredients)).apply((Applicative)instance, ConcoctingItemRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConcoctingItemRecipe> STREAM_CODEC = StreamCodec.of(ConcoctingItemRecipeSerializer::toNetwork, ConcoctingItemRecipeSerializer::fromNetwork);

    public MapCodec<ConcoctingItemRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ConcoctingItemRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    public static ConcoctingItemRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
        int burnTime = pBuffer.readInt();
        int color = pBuffer.readInt();
        ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
        NonNullList ingredients = NonNullList.withSize((int)pBuffer.readInt(), (Object)Ingredient.EMPTY);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer)));
        }
        return new ConcoctingItemRecipe(burnTime, color, output, (List<Ingredient>)ingredients);
    }

    public static void toNetwork(RegistryFriendlyByteBuf pBuffer, ConcoctingItemRecipe pRecipe) {
        pBuffer.writeInt(pRecipe.burnTime);
        pBuffer.writeInt(pRecipe.color);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.output);
        pBuffer.writeInt(pRecipe.getIngredients().size());
        for (Ingredient ingredient : pRecipe.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)ingredient);
        }
    }
}

