/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.recipe.serializer;

import com.axanthic.icaria.common.recipe.ConcoctingPotionRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConcoctingPotionRecipeSerializer
implements RecipeSerializer<ConcoctingPotionRecipe> {
    public static final MapCodec<ConcoctingPotionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("potionRadius").forGetter(recipe -> Float.valueOf(recipe.potionRadius)), (App)Codec.INT.fieldOf("burnTime").forGetter(recipe -> recipe.burnTime), (App)Codec.INT.fieldOf("color").forGetter(recipe -> recipe.color), (App)Codec.INT.fieldOf("potionDuration").forGetter(recipe -> recipe.potionDuration), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)PotionContents.CODEC.fieldOf("potion").forGetter(recipe -> recipe.potion)).apply((Applicative)instance, ConcoctingPotionRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConcoctingPotionRecipe> STREAM_CODEC = StreamCodec.of(ConcoctingPotionRecipeSerializer::toNetwork, ConcoctingPotionRecipeSerializer::fromNetwork);

    public MapCodec<ConcoctingPotionRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ConcoctingPotionRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    public static ConcoctingPotionRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
        float potionRadius = pBuffer.readFloat();
        int burnTime = pBuffer.readInt();
        int color = pBuffer.readInt();
        int potionDuration = pBuffer.readInt();
        PotionContents potion = (PotionContents)PotionContents.STREAM_CODEC.decode((Object)pBuffer);
        NonNullList ingredients = NonNullList.withSize((int)pBuffer.readInt(), (Object)Ingredient.EMPTY);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer)));
        }
        return new ConcoctingPotionRecipe(potionRadius, burnTime, color, potionDuration, (List<Ingredient>)ingredients, potion);
    }

    public static void toNetwork(RegistryFriendlyByteBuf pBuffer, ConcoctingPotionRecipe pRecipe) {
        pBuffer.writeFloat(pRecipe.potionRadius);
        pBuffer.writeInt(pRecipe.burnTime);
        pBuffer.writeInt(pRecipe.color);
        pBuffer.writeInt(pRecipe.potionDuration);
        PotionContents.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.potion);
        pBuffer.writeInt(pRecipe.getIngredients().size());
        for (Ingredient ingredient : pRecipe.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)ingredient);
        }
    }
}

