/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.recipe.serializer;

import com.axanthic.icaria.common.recipe.ForgingRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ForgingRecipeSerializer
implements RecipeSerializer<ForgingRecipe> {
    public static final MapCodec<ForgingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("experience").forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.fieldOf("burnTime").forGetter(recipe -> recipe.burnTime), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(recipe -> recipe.output)).apply((Applicative)instance, ForgingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ForgingRecipe> STREAM_CODEC = StreamCodec.of(ForgingRecipeSerializer::toNetwork, ForgingRecipeSerializer::fromNetwork);

    public MapCodec<ForgingRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ForgingRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    public static ForgingRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
        float experience = pBuffer.readFloat();
        int burnTime = pBuffer.readInt();
        ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
        NonNullList ingredients = NonNullList.withSize((int)pBuffer.readInt(), (Object)Ingredient.of());
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer)));
        }
        return new ForgingRecipe(experience, burnTime, (List<Ingredient>)ingredients, output);
    }

    public static void toNetwork(RegistryFriendlyByteBuf pBuffer, ForgingRecipe pRecipe) {
        pBuffer.writeFloat(pRecipe.experience);
        pBuffer.writeInt(pRecipe.burnTime);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.output);
        pBuffer.writeInt(pRecipe.getIngredients().size());
        for (Ingredient ingredient : pRecipe.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)ingredient);
        }
    }
}

