/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.recipe.serializer;

import com.axanthic.icaria.common.recipe.GrindingRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GrindingRecipeSerializer
implements RecipeSerializer<GrindingRecipe> {
    public static final MapCodec<GrindingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("experience").forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.fieldOf("burnTime").forGetter(recipe -> recipe.burnTime), (App)Ingredient.CODEC.fieldOf("gear").forGetter(recipe -> recipe.gear), (App)Ingredient.LIST_CODEC.fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)ItemStack.CODEC.fieldOf("output").forGetter(recipe -> recipe.output)).apply((Applicative)instance, GrindingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GrindingRecipe> STREAM_CODEC = StreamCodec.of(GrindingRecipeSerializer::toNetwork, GrindingRecipeSerializer::fromNetwork);

    public MapCodec<GrindingRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, GrindingRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    public static GrindingRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
        float experience = pBuffer.readFloat();
        int burnTime = pBuffer.readInt();
        Ingredient gear = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
        ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)pBuffer);
        NonNullList ingredients = NonNullList.withSize((int)pBuffer.readInt(), (Object)Ingredient.EMPTY);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer)));
        }
        return new GrindingRecipe(experience, burnTime, gear, (List<Ingredient>)ingredients, output);
    }

    public static void toNetwork(RegistryFriendlyByteBuf pBuffer, GrindingRecipe pRecipe) {
        pBuffer.writeFloat(pRecipe.experience);
        pBuffer.writeInt(pRecipe.burnTime);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.gear);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.output);
        pBuffer.writeInt(pRecipe.getIngredients().size());
        for (Ingredient ingredient : pRecipe.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)ingredient);
        }
    }
}

