/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.registry;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaFluidTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.DeferredRegister;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"landsoficaria");
    public static final Supplier<FlowingFluid> FLOWING_MEDITERRANEAN_WATER = IcariaFluids.registerMediterraneanWater("flowing_mediterranean_water", BaseFlowingFluid.Flowing::new);
    public static final Supplier<FlowingFluid> MEDITERRANEAN_WATER = IcariaFluids.registerMediterraneanWater("mediterranean_water", BaseFlowingFluid.Source::new);

    public static Supplier<FlowingFluid> registerMediterraneanWater(String pName, Function<BaseFlowingFluid.Properties, FlowingFluid> pFunction) {
        return FLUIDS.register(pName, () -> (FlowingFluid)pFunction.apply(new BaseFlowingFluid.Properties(IcariaFluidTypes.MEDITERRANEAN_WATER, MEDITERRANEAN_WATER, FLOWING_MEDITERRANEAN_WATER).bucket(IcariaItems.MEDITERRANEAN_WATER_BUCKET).block(IcariaBlocks.MEDITERRANEAN_WATER)));
    }
}

