/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.registry;

import com.axanthic.icaria.common.registry.IcariaBiomes;
import com.axanthic.icaria.common.registry.IcariaDimensionTypes;
import com.axanthic.icaria.common.registry.IcariaNoiseSettings;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaLevelStems {
    public static final Climate.Parameter VERY_COLD = Climate.Parameter.span((float)-1.0f, (float)-0.5f);
    public static final Climate.Parameter COLD = Climate.Parameter.span((float)-0.5f, (float)0.0f);
    public static final Climate.Parameter WARM = Climate.Parameter.span((float)0.0f, (float)0.5f);
    public static final Climate.Parameter VERY_WARM = Climate.Parameter.span((float)0.5f, (float)1.0f);
    public static final Climate.Parameter FULL = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    public static final Climate.Parameter LAND = Climate.Parameter.span((float)0.0f, (float)0.75f);
    public static final Climate.Parameter VOID = Climate.Parameter.span((float)-1.0f, (float)0.0f);
    public static final Climate.Parameter BASE = Climate.Parameter.span((float)0.5f, (float)1.0f);
    public static final Climate.Parameter LUSH = Climate.Parameter.span((float)0.0f, (float)0.5f);
    public static final Climate.Parameter LOST = Climate.Parameter.span((float)-0.5f, (float)0.0f);
    public static final Climate.Parameter DEEP = Climate.Parameter.span((float)-1.0f, (float)-0.5f);
    public static final Climate.Parameter ZERO = Climate.Parameter.point((float)0.0f);
    public static final ResourceKey<LevelStem> ICARIA = IcariaLevelStems.createKey("icaria");

    public static void bootstrap(BootstrapContext<LevelStem> pContext) {
        HolderGetter biomes = pContext.lookup(Registries.BIOME);
        pContext.register(ICARIA, (Object)new LevelStem((Holder)pContext.lookup(Registries.DIMENSION_TYPE).getOrThrow(IcariaDimensionTypes.ICARIA), (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(List.of(IcariaLevelStems.forestParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.lushForestParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.lostForestParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.deepForestParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.scrublandParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.lushScrublandParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.lostScrublandParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.deepScrublandParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.steppeParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.lushSteppeParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.lostSteppeParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.deepSteppeParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.desertParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.lushDesertParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.lostDesertParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.deepDesertParameters((HolderGetter<Biome>)biomes), IcariaLevelStems.voidParameters((HolderGetter<Biome>)biomes)))), (Holder)pContext.lookup(Registries.NOISE_SETTINGS).getOrThrow(IcariaNoiseSettings.ICARIA))));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> forestParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(VERY_COLD, ZERO, LAND, ZERO, BASE, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.FOREST));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> lushForestParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(VERY_COLD, ZERO, LAND, ZERO, LUSH, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.LUSH_FOREST));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> lostForestParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(VERY_COLD, ZERO, LAND, ZERO, LOST, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.LOST_FOREST));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> deepForestParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(VERY_COLD, ZERO, LAND, ZERO, DEEP, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.DEEP_FOREST));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> scrublandParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(COLD, ZERO, LAND, ZERO, BASE, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.SCRUBLAND));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> lushScrublandParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(COLD, ZERO, LAND, ZERO, LUSH, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.LUSH_SCRUBLAND));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> lostScrublandParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(COLD, ZERO, LAND, ZERO, LOST, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.LOST_SCRUBLAND));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> deepScrublandParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(COLD, ZERO, LAND, ZERO, DEEP, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.DEEP_SCRUBLAND));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> steppeParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(WARM, ZERO, LAND, ZERO, BASE, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.STEPPE));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> lushSteppeParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(WARM, ZERO, LAND, ZERO, LUSH, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.LUSH_STEPPE));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> lostSteppeParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(WARM, ZERO, LAND, ZERO, LOST, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.LOST_STEPPE));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> deepSteppeParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(WARM, ZERO, LAND, ZERO, DEEP, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.DEEP_STEPPE));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> desertParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(VERY_WARM, ZERO, LAND, ZERO, BASE, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.DESERT));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> lushDesertParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(VERY_WARM, ZERO, LAND, ZERO, LUSH, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.LUSH_DESERT));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> lostDesertParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(VERY_WARM, ZERO, LAND, ZERO, LOST, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.LOST_DESERT));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> deepDesertParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(VERY_WARM, ZERO, LAND, ZERO, DEEP, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.DEEP_DESERT));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> voidParameters(HolderGetter<Biome> pBiomes) {
        return new Pair((Object)new Climate.ParameterPoint(FULL, ZERO, VOID, ZERO, FULL, ZERO, 0L), (Object)pBiomes.getOrThrow(IcariaBiomes.VOID));
    }

    public static ResourceKey<LevelStem> createKey(String pName) {
        return ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"landsoficaria", (String)pName));
    }
}

