/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.registry;

import com.axanthic.icaria.common.registry.IcariaBiomes;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaNoiseSettings {
    public static final Climate.Parameter NIL = Climate.Parameter.point((float)0.0f);
    public static final Climate.Parameter ONE = Climate.Parameter.point((float)1.0f);
    public static final ResourceKey<NoiseGeneratorSettings> ICARIA = IcariaNoiseSettings.createKey("icaria");

    public static void bootstrap(BootstrapContext<NoiseGeneratorSettings> pContext) {
        pContext.register(ICARIA, (Object)new NoiseGeneratorSettings(new NoiseSettings(0, 96, 1, 1), Blocks.STONE.defaultBlockState(), Blocks.AIR.defaultBlockState(), IcariaNoiseSettings.noiseRouter(pContext), IcariaNoiseSettings.surfaceRules(), List.of(new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)1.0f), NIL, ONE, NIL, ONE, NIL, 0L)), -1, false, false, false, false));
    }

    public static NoiseRouter noiseRouter(BootstrapContext<NoiseGeneratorSettings> pContext) {
        HolderGetter noises = pContext.lookup(Registries.NOISE);
        DensityFunction densityFunctionA = DensityFunctions.noise((Holder)noises.getOrThrow(Noises.TEMPERATURE), (double)1.0, (double)0.0);
        DensityFunction densityFunctionB = DensityFunctions.noise((Holder)noises.getOrThrow(Noises.CONTINENTALNESS), (double)3.0, (double)1.5);
        DensityFunction densityFunctionC = DensityFunctions.yClampedGradient((int)0, (int)12, (double)-1.0, (double)0.0);
        DensityFunction densityFunctionD = DensityFunctions.add((DensityFunction)densityFunctionC, (DensityFunction)densityFunctionB);
        DensityFunction densityFunctionE = DensityFunctions.yClampedGradient((int)12, (int)24, (double)0.0, (double)-0.5);
        DensityFunction densityFunctionF = DensityFunctions.add((DensityFunction)densityFunctionE, (DensityFunction)densityFunctionD);
        DensityFunction densityFunctionG = DensityFunctions.yClampedGradient((int)24, (int)36, (double)0.0, (double)0.5);
        DensityFunction densityFunctionH = DensityFunctions.add((DensityFunction)densityFunctionG, (DensityFunction)densityFunctionF);
        DensityFunction densityFunctionI = DensityFunctions.yClampedGradient((int)36, (int)48, (double)0.0, (double)-0.5);
        DensityFunction densityFunctionJ = DensityFunctions.add((DensityFunction)densityFunctionI, (DensityFunction)densityFunctionH);
        DensityFunction densityFunctionK = DensityFunctions.yClampedGradient((int)48, (int)60, (double)0.0, (double)0.5);
        DensityFunction densityFunctionL = DensityFunctions.add((DensityFunction)densityFunctionK, (DensityFunction)densityFunctionJ);
        DensityFunction densityFunctionM = DensityFunctions.yClampedGradient((int)60, (int)72, (double)0.0, (double)-0.5);
        DensityFunction densityFunctionN = DensityFunctions.add((DensityFunction)densityFunctionM, (DensityFunction)densityFunctionL);
        DensityFunction densityFunctionO = DensityFunctions.yClampedGradient((int)72, (int)84, (double)0.0, (double)0.5);
        DensityFunction densityFunctionP = DensityFunctions.add((DensityFunction)densityFunctionO, (DensityFunction)densityFunctionN);
        DensityFunction densityFunctionQ = DensityFunctions.yClampedGradient((int)84, (int)96, (double)0.0, (double)-1.0);
        DensityFunction densityFunctionR = DensityFunctions.add((DensityFunction)densityFunctionQ, (DensityFunction)densityFunctionP);
        DensityFunction densityFunctionS = DensityFunctions.yClampedGradient((int)0, (int)96, (double)-1.0, (double)1.0);
        return new NoiseRouter(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), densityFunctionA, DensityFunctions.zero(), densityFunctionB, DensityFunctions.zero(), densityFunctionS, DensityFunctions.zero(), DensityFunctions.zero(), densityFunctionR, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    public static SurfaceRules.RuleSource surfaceRules() {
        SurfaceRules.RuleSource surfaceRuleA = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{IcariaBiomes.FOREST, IcariaBiomes.LUSH_FOREST, IcariaBiomes.LOST_FOREST, IcariaBiomes.DEEP_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)0.5, (double)2.0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.COARSE_MARL.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-2.0, (double)0.5), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.GRASSY_MARL.get().defaultBlockState()))})));
        SurfaceRules.RuleSource surfaceRuleB = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)8, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{IcariaBiomes.FOREST, IcariaBiomes.LUSH_FOREST, IcariaBiomes.LOST_FOREST, IcariaBiomes.DEEP_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)0.5, (double)2.0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.COARSE_MARL.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-2.0, (double)0.5), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.MARL.get().defaultBlockState()))})));
        SurfaceRules.RuleSource surfaceRuleC = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{IcariaBiomes.SCRUBLAND, IcariaBiomes.LUSH_SCRUBLAND, IcariaBiomes.LOST_SCRUBLAND, IcariaBiomes.DEEP_SCRUBLAND, IcariaBiomes.STEPPE, IcariaBiomes.LUSH_STEPPE, IcariaBiomes.LOST_STEPPE, IcariaBiomes.DEEP_STEPPE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)0.2, (double)2.0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.LOAM.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-0.2, (double)0.2), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.COARSE_MARL.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-2.0, (double)-0.2), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.GRASSY_MARL.get().defaultBlockState()))})));
        SurfaceRules.RuleSource surfaceRuleD = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)8, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{IcariaBiomes.SCRUBLAND, IcariaBiomes.LUSH_SCRUBLAND, IcariaBiomes.LOST_SCRUBLAND, IcariaBiomes.DEEP_SCRUBLAND, IcariaBiomes.STEPPE, IcariaBiomes.LUSH_STEPPE, IcariaBiomes.LOST_STEPPE, IcariaBiomes.DEEP_STEPPE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)0.2, (double)2.0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.LOAM.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-0.2, (double)0.2), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.COARSE_MARL.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-2.0, (double)-0.2), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.MARL.get().defaultBlockState()))})));
        SurfaceRules.RuleSource surfaceRuleE = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)8, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{IcariaBiomes.DESERT, IcariaBiomes.LUSH_DESERT, IcariaBiomes.LOST_DESERT, IcariaBiomes.DEEP_DESERT}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)0.2, (double)2.0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.LOAM.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-0.2, (double)0.2), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.SILKSAND.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-2.0, (double)-0.2), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.GRAINEL.get().defaultBlockState()))})));
        SurfaceRules.RuleSource surfaceRuleF = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)0), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{IcariaBiomes.VOID}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.AIR.defaultBlockState())));
        SurfaceRules.RuleSource surfaceRuleG = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)64), (int)2), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.YELLOWSTONE.get().defaultBlockState()));
        SurfaceRules.RuleSource surfaceRuleH = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)48), (int)2), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.SILKSTONE.get().defaultBlockState()));
        SurfaceRules.RuleSource surfaceRuleI = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)32), (int)2), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.SUNSTONE.get().defaultBlockState()));
        SurfaceRules.RuleSource surfaceRuleJ = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)16), (int)2), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.VOIDSHALE.get().defaultBlockState()));
        SurfaceRules.RuleSource surfaceRuleK = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)0), (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)IcariaBlocks.BAETYL.get().defaultBlockState()));
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfaceRuleA, surfaceRuleB, surfaceRuleC, surfaceRuleD, surfaceRuleE, surfaceRuleF, surfaceRuleG, surfaceRuleH, surfaceRuleI, surfaceRuleJ, surfaceRuleK});
    }

    public static ResourceKey<NoiseGeneratorSettings> createKey(String pName) {
        return ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"landsoficaria", (String)pName));
    }
}

