/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.registry;

import com.axanthic.icaria.common.properties.VerticalCorner;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.AxisAlignedLinearPosTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaProcessorLists {
    public static final ResourceKey<StructureProcessorList> RUIN = IcariaProcessorLists.createKey("ruin");
    public static final ResourceKey<StructureProcessorList> TEMPLE = IcariaProcessorLists.createKey("temple");
    public static final ResourceKey<StructureProcessorList> ERODED_DOLOMITE_FOREST_VILLAGE = IcariaProcessorLists.createKey("villages/forest/eroded/dolomite");
    public static final ResourceKey<StructureProcessorList> ERODED_SILKSTONE_FOREST_VILLAGE = IcariaProcessorLists.createKey("villages/forest/eroded/silkstone");
    public static final ResourceKey<StructureProcessorList> ERODED_SUNSTONE_FOREST_VILLAGE = IcariaProcessorLists.createKey("villages/forest/eroded/sunstone");
    public static final ResourceKey<StructureProcessorList> PRISTINE_DOLOMITE_FOREST_VILLAGE = IcariaProcessorLists.createKey("villages/forest/pristine/dolomite");
    public static final ResourceKey<StructureProcessorList> PRISTINE_SILKSTONE_FOREST_VILLAGE = IcariaProcessorLists.createKey("villages/forest/pristine/silkstone");
    public static final ResourceKey<StructureProcessorList> PRISTINE_SUNSTONE_FOREST_VILLAGE = IcariaProcessorLists.createKey("villages/forest/pristine/sunstone");
    public static final ResourceKey<StructureProcessorList> RUINED_DOLOMITE_FOREST_VILLAGE = IcariaProcessorLists.createKey("villages/forest/ruined/dolomite");
    public static final ResourceKey<StructureProcessorList> RUINED_SILKSTONE_FOREST_VILLAGE = IcariaProcessorLists.createKey("villages/forest/ruined/silkstone");
    public static final ResourceKey<StructureProcessorList> RUINED_SUNSTONE_FOREST_VILLAGE = IcariaProcessorLists.createKey("villages/forest/ruined/sunstone");
    public static final ResourceKey<StructureProcessorList> ERODED_SUNSTONE_SCRUBLAND_VILLAGE = IcariaProcessorLists.createKey("villages/scrubland/eroded/sunstone");
    public static final ResourceKey<StructureProcessorList> ERODED_VOIDSHALE_SCRUBLAND_VILLAGE = IcariaProcessorLists.createKey("villages/scrubland/eroded/voidshale");
    public static final ResourceKey<StructureProcessorList> ERODED_YELLOWSTONE_SCRUBLAND_VILLAGE = IcariaProcessorLists.createKey("villages/scrubland/eroded/yellowstone");
    public static final ResourceKey<StructureProcessorList> PRISTINE_SUNSTONE_SCRUBLAND_VILLAGE = IcariaProcessorLists.createKey("villages/scrubland/pristine/sunstone");
    public static final ResourceKey<StructureProcessorList> PRISTINE_VOIDSHALE_SCRUBLAND_VILLAGE = IcariaProcessorLists.createKey("villages/scrubland/pristine/voidshale");
    public static final ResourceKey<StructureProcessorList> PRISTINE_YELLOWSTONE_SCRUBLAND_VILLAGE = IcariaProcessorLists.createKey("villages/scrubland/pristine/yellowstone");
    public static final ResourceKey<StructureProcessorList> RUINED_SUNSTONE_SCRUBLAND_VILLAGE = IcariaProcessorLists.createKey("villages/scrubland/ruined/sunstone");
    public static final ResourceKey<StructureProcessorList> RUINED_VOIDSHALE_SCRUBLAND_VILLAGE = IcariaProcessorLists.createKey("villages/scrubland/ruined/voidshale");
    public static final ResourceKey<StructureProcessorList> RUINED_YELLOWSTONE_SCRUBLAND_VILLAGE = IcariaProcessorLists.createKey("villages/scrubland/ruined/yellowstone");
    public static final ResourceKey<StructureProcessorList> ERODED_GRAINITE_STEPPE_VILLAGE = IcariaProcessorLists.createKey("villages/steppe/eroded/grainite");
    public static final ResourceKey<StructureProcessorList> ERODED_MARL_STEPPE_VILLAGE = IcariaProcessorLists.createKey("villages/steppe/eroded/marl");
    public static final ResourceKey<StructureProcessorList> ERODED_YELLOWSTONE_STEPPE_VILLAGE = IcariaProcessorLists.createKey("villages/steppe/eroded/yellowstone");
    public static final ResourceKey<StructureProcessorList> PRISTINE_GRAINITE_STEPPE_VILLAGE = IcariaProcessorLists.createKey("villages/steppe/pristine/grainite");
    public static final ResourceKey<StructureProcessorList> PRISTINE_MARL_STEPPE_VILLAGE = IcariaProcessorLists.createKey("villages/steppe/pristine/marl");
    public static final ResourceKey<StructureProcessorList> PRISTINE_YELLOWSTONE_STEPPE_VILLAGE = IcariaProcessorLists.createKey("villages/steppe/pristine/yellowstone");
    public static final ResourceKey<StructureProcessorList> RUINED_GRAINITE_STEPPE_VILLAGE = IcariaProcessorLists.createKey("villages/steppe/ruined/grainite");
    public static final ResourceKey<StructureProcessorList> RUINED_MARL_STEPPE_VILLAGE = IcariaProcessorLists.createKey("villages/steppe/ruined/marl");
    public static final ResourceKey<StructureProcessorList> RUINED_YELLOWSTONE_STEPPE_VILLAGE = IcariaProcessorLists.createKey("villages/steppe/ruined/yellowstone");
    public static final ResourceKey<StructureProcessorList> ERODED_BAETYL_DESERT_VILLAGE = IcariaProcessorLists.createKey("villages/desert/eroded/baetyl");
    public static final ResourceKey<StructureProcessorList> ERODED_GRAINITE_DESERT_VILLAGE = IcariaProcessorLists.createKey("villages/desert/eroded/grainite");
    public static final ResourceKey<StructureProcessorList> ERODED_VOIDSHALE_DESERT_VILLAGE = IcariaProcessorLists.createKey("villages/desert/eroded/voidshale");
    public static final ResourceKey<StructureProcessorList> PRISTINE_BAETYL_DESERT_VILLAGE = IcariaProcessorLists.createKey("villages/desert/pristine/baetyl");
    public static final ResourceKey<StructureProcessorList> PRISTINE_GRAINITE_DESERT_VILLAGE = IcariaProcessorLists.createKey("villages/desert/pristine/grainite");
    public static final ResourceKey<StructureProcessorList> PRISTINE_VOIDSHALE_DESERT_VILLAGE = IcariaProcessorLists.createKey("villages/desert/pristine/voidshale");
    public static final ResourceKey<StructureProcessorList> RUINED_BAETYL_DESERT_VILLAGE = IcariaProcessorLists.createKey("villages/desert/ruined/baetyl");
    public static final ResourceKey<StructureProcessorList> RUINED_GRAINITE_DESERT_VILLAGE = IcariaProcessorLists.createKey("villages/desert/ruined/grainite");
    public static final ResourceKey<StructureProcessorList> RUINED_VOIDSHALE_DESERT_VILLAGE = IcariaProcessorLists.createKey("villages/desert/ruined/voidshale");

    public static void bootstrap(BootstrapContext<StructureProcessorList> pContext) {
        pContext.register(RUIN, (Object)IcariaProcessorLists.ruin());
        pContext.register(TEMPLE, (Object)IcariaProcessorLists.temple());
        pContext.register(ERODED_DOLOMITE_FOREST_VILLAGE, (Object)IcariaProcessorLists.erodedForestVillage(IcariaBlocks.DOLOMITE_ADOBE.get(), (Block)IcariaBlocks.DOLOMITE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.DOLOMITE_ADOBE_DECO.slab.get()));
        pContext.register(ERODED_SILKSTONE_FOREST_VILLAGE, (Object)IcariaProcessorLists.erodedForestVillage(IcariaBlocks.SILKSTONE_ADOBE.get(), (Block)IcariaBlocks.SILKSTONE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.SILKSTONE_ADOBE_DECO.slab.get()));
        pContext.register(ERODED_SUNSTONE_FOREST_VILLAGE, (Object)IcariaProcessorLists.erodedForestVillage(IcariaBlocks.SUNSTONE_ADOBE.get(), (Block)IcariaBlocks.SUNSTONE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.SUNSTONE_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_DOLOMITE_FOREST_VILLAGE, (Object)IcariaProcessorLists.pristineForestVillage(IcariaBlocks.DOLOMITE_ADOBE.get(), (Block)IcariaBlocks.DOLOMITE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.DOLOMITE_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_SILKSTONE_FOREST_VILLAGE, (Object)IcariaProcessorLists.pristineForestVillage(IcariaBlocks.SILKSTONE_ADOBE.get(), (Block)IcariaBlocks.SILKSTONE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.SILKSTONE_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_SUNSTONE_FOREST_VILLAGE, (Object)IcariaProcessorLists.pristineForestVillage(IcariaBlocks.SUNSTONE_ADOBE.get(), (Block)IcariaBlocks.SUNSTONE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.SUNSTONE_ADOBE_DECO.slab.get()));
        pContext.register(RUINED_DOLOMITE_FOREST_VILLAGE, (Object)IcariaProcessorLists.ruinedForestVillage(IcariaBlocks.DOLOMITE_ADOBE.get()));
        pContext.register(RUINED_SILKSTONE_FOREST_VILLAGE, (Object)IcariaProcessorLists.ruinedForestVillage(IcariaBlocks.SILKSTONE_ADOBE.get()));
        pContext.register(RUINED_SUNSTONE_FOREST_VILLAGE, (Object)IcariaProcessorLists.ruinedForestVillage(IcariaBlocks.SUNSTONE_ADOBE.get()));
        pContext.register(ERODED_SUNSTONE_SCRUBLAND_VILLAGE, (Object)IcariaProcessorLists.erodedScrublandVillage(IcariaBlocks.SUNSTONE_ADOBE.get(), (Block)IcariaBlocks.SUNSTONE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.SUNSTONE_ADOBE_DECO.slab.get()));
        pContext.register(ERODED_VOIDSHALE_SCRUBLAND_VILLAGE, (Object)IcariaProcessorLists.erodedScrublandVillage(IcariaBlocks.VOIDSHALE_ADOBE.get(), (Block)IcariaBlocks.VOIDSHALE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.VOIDSHALE_ADOBE_DECO.slab.get()));
        pContext.register(ERODED_YELLOWSTONE_SCRUBLAND_VILLAGE, (Object)IcariaProcessorLists.erodedScrublandVillage(IcariaBlocks.YELLOWSTONE_ADOBE.get(), (Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_SUNSTONE_SCRUBLAND_VILLAGE, (Object)IcariaProcessorLists.pristineScrublandVillage(IcariaBlocks.SUNSTONE_ADOBE.get(), (Block)IcariaBlocks.SUNSTONE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.SUNSTONE_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_VOIDSHALE_SCRUBLAND_VILLAGE, (Object)IcariaProcessorLists.pristineScrublandVillage(IcariaBlocks.VOIDSHALE_ADOBE.get(), (Block)IcariaBlocks.VOIDSHALE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.VOIDSHALE_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_YELLOWSTONE_SCRUBLAND_VILLAGE, (Object)IcariaProcessorLists.pristineScrublandVillage(IcariaBlocks.YELLOWSTONE_ADOBE.get(), (Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.slab.get()));
        pContext.register(RUINED_SUNSTONE_SCRUBLAND_VILLAGE, (Object)IcariaProcessorLists.ruinedScrublandVillage(IcariaBlocks.SUNSTONE_ADOBE.get()));
        pContext.register(RUINED_VOIDSHALE_SCRUBLAND_VILLAGE, (Object)IcariaProcessorLists.ruinedScrublandVillage(IcariaBlocks.VOIDSHALE_ADOBE.get()));
        pContext.register(RUINED_YELLOWSTONE_SCRUBLAND_VILLAGE, (Object)IcariaProcessorLists.ruinedScrublandVillage(IcariaBlocks.YELLOWSTONE_ADOBE.get()));
        pContext.register(ERODED_GRAINITE_STEPPE_VILLAGE, (Object)IcariaProcessorLists.erodedSteppeVillage(IcariaBlocks.GRAINITE_ADOBE.get(), (Block)IcariaBlocks.GRAINITE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.GRAINITE_ADOBE_DECO.slab.get()));
        pContext.register(ERODED_MARL_STEPPE_VILLAGE, (Object)IcariaProcessorLists.erodedSteppeVillage(IcariaBlocks.MARL_ADOBE.get(), (Block)IcariaBlocks.MARL_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.MARL_ADOBE_DECO.slab.get()));
        pContext.register(ERODED_YELLOWSTONE_STEPPE_VILLAGE, (Object)IcariaProcessorLists.erodedSteppeVillage(IcariaBlocks.YELLOWSTONE_ADOBE.get(), (Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_GRAINITE_STEPPE_VILLAGE, (Object)IcariaProcessorLists.pristineSteppeVillage(IcariaBlocks.GRAINITE_ADOBE.get(), (Block)IcariaBlocks.GRAINITE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.GRAINITE_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_MARL_STEPPE_VILLAGE, (Object)IcariaProcessorLists.pristineSteppeVillage(IcariaBlocks.MARL_ADOBE.get(), (Block)IcariaBlocks.MARL_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.MARL_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_YELLOWSTONE_STEPPE_VILLAGE, (Object)IcariaProcessorLists.pristineSteppeVillage(IcariaBlocks.YELLOWSTONE_ADOBE.get(), (Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.slab.get()));
        pContext.register(RUINED_GRAINITE_STEPPE_VILLAGE, (Object)IcariaProcessorLists.ruinedSteppeVillage(IcariaBlocks.GRAINITE_ADOBE.get()));
        pContext.register(RUINED_MARL_STEPPE_VILLAGE, (Object)IcariaProcessorLists.ruinedSteppeVillage(IcariaBlocks.MARL_ADOBE.get()));
        pContext.register(RUINED_YELLOWSTONE_STEPPE_VILLAGE, (Object)IcariaProcessorLists.ruinedSteppeVillage(IcariaBlocks.YELLOWSTONE_ADOBE.get()));
        pContext.register(ERODED_BAETYL_DESERT_VILLAGE, (Object)IcariaProcessorLists.erodedDesertVillage(IcariaBlocks.BAETYL_ADOBE.get(), (Block)IcariaBlocks.BAETYL_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.BAETYL_ADOBE_DECO.slab.get()));
        pContext.register(ERODED_GRAINITE_DESERT_VILLAGE, (Object)IcariaProcessorLists.erodedDesertVillage(IcariaBlocks.GRAINITE_ADOBE.get(), (Block)IcariaBlocks.GRAINITE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.GRAINITE_ADOBE_DECO.slab.get()));
        pContext.register(ERODED_VOIDSHALE_DESERT_VILLAGE, (Object)IcariaProcessorLists.erodedDesertVillage(IcariaBlocks.VOIDSHALE_ADOBE.get(), (Block)IcariaBlocks.VOIDSHALE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.VOIDSHALE_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_BAETYL_DESERT_VILLAGE, (Object)IcariaProcessorLists.pristineDesertVillage(IcariaBlocks.BAETYL_ADOBE.get(), (Block)IcariaBlocks.BAETYL_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.BAETYL_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_GRAINITE_DESERT_VILLAGE, (Object)IcariaProcessorLists.pristineDesertVillage(IcariaBlocks.GRAINITE_ADOBE.get(), (Block)IcariaBlocks.GRAINITE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.GRAINITE_ADOBE_DECO.slab.get()));
        pContext.register(PRISTINE_VOIDSHALE_DESERT_VILLAGE, (Object)IcariaProcessorLists.pristineDesertVillage(IcariaBlocks.VOIDSHALE_ADOBE.get(), (Block)IcariaBlocks.VOIDSHALE_ADOBE_DECO.stairs.get(), (Block)IcariaBlocks.VOIDSHALE_ADOBE_DECO.slab.get()));
        pContext.register(RUINED_BAETYL_DESERT_VILLAGE, (Object)IcariaProcessorLists.ruinedDesertVillage(IcariaBlocks.BAETYL_ADOBE.get()));
        pContext.register(RUINED_GRAINITE_DESERT_VILLAGE, (Object)IcariaProcessorLists.ruinedDesertVillage(IcariaBlocks.GRAINITE_ADOBE.get()));
        pContext.register(RUINED_VOIDSHALE_DESERT_VILLAGE, (Object)IcariaProcessorLists.ruinedDesertVillage(IcariaBlocks.VOIDSHALE_ADOBE.get()));
    }

    public static StructureProcessorList ruin() {
        return new StructureProcessorList((List)ImmutableList.of((Object)IcariaProcessorLists.block(IcariaBlocks.RELICSTONE_TILES.get(), 0.25f, IcariaBlocks.CRACKED_RELICSTONE_TILES.get(), 0.25f, IcariaBlocks.MOSSY_RELICSTONE_TILES.get()), (Object)IcariaProcessorLists.stairs((Block)IcariaBlocks.RELICSTONE_TILE_DECO.stairs.get(), 0.25f, (Block)IcariaBlocks.CRACKED_RELICSTONE_TILE_DECO.stairs.get(), 0.25f, (Block)IcariaBlocks.MOSSY_RELICSTONE_TILE_DECO.stairs.get()), (Object)IcariaProcessorLists.slab((Block)IcariaBlocks.RELICSTONE_TILE_DECO.slab.get(), 0.25f, (Block)IcariaBlocks.CRACKED_RELICSTONE_TILE_DECO.slab.get(), 0.25f, (Block)IcariaBlocks.MOSSY_RELICSTONE_TILE_DECO.slab.get()), (Object)IcariaProcessorLists.block(IcariaBlocks.LOST_LOOT_VASE.get(), 0.5f, IcariaBlocks.REVENANT_SPAWNER.get())));
    }

    public static StructureProcessorList temple() {
        return new StructureProcessorList((List)ImmutableList.of((Object)IcariaProcessorLists.block(IcariaBlocks.RELICSTONE_BRICKS.get(), 0.25f, IcariaBlocks.CRACKED_RELICSTONE_BRICKS.get(), 0.25f, IcariaBlocks.MOSSY_RELICSTONE_BRICKS.get()), (Object)IcariaProcessorLists.stairs((Block)IcariaBlocks.RELICSTONE_BRICK_DECO.stairs.get(), 0.25f, (Block)IcariaBlocks.CRACKED_RELICSTONE_BRICK_DECO.stairs.get(), 0.25f, (Block)IcariaBlocks.MOSSY_RELICSTONE_BRICK_DECO.stairs.get()), (Object)IcariaProcessorLists.slab((Block)IcariaBlocks.RELICSTONE_BRICK_DECO.slab.get(), 0.25f, (Block)IcariaBlocks.CRACKED_RELICSTONE_BRICK_DECO.slab.get(), 0.25f, (Block)IcariaBlocks.MOSSY_RELICSTONE_BRICK_DECO.slab.get()), (Object)IcariaProcessorLists.block(IcariaBlocks.RELICSTONE_TILES.get(), 0.25f, IcariaBlocks.CRACKED_RELICSTONE_TILES.get(), 0.25f, IcariaBlocks.MOSSY_RELICSTONE_TILES.get()), (Object)IcariaProcessorLists.stairs((Block)IcariaBlocks.RELICSTONE_TILE_DECO.stairs.get(), 0.25f, (Block)IcariaBlocks.CRACKED_RELICSTONE_TILE_DECO.stairs.get(), 0.25f, (Block)IcariaBlocks.MOSSY_RELICSTONE_TILE_DECO.stairs.get()), (Object)IcariaProcessorLists.slab((Block)IcariaBlocks.RELICSTONE_TILE_DECO.slab.get(), 0.25f, (Block)IcariaBlocks.CRACKED_RELICSTONE_TILE_DECO.slab.get(), 0.25f, (Block)IcariaBlocks.MOSSY_RELICSTONE_TILE_DECO.slab.get()), (Object)IcariaProcessorLists.block(IcariaBlocks.RED_LOOT_VASE.get(), 0.1f, IcariaBlocks.CYAN_LOOT_VASE.get(), 0.2f, IcariaBlocks.REVENANT_SPAWNER.get(), 0.2f, Blocks.AIR)));
    }

    public static StructureProcessorList erodedForestVillage(Block pAdobeBlock, Block pAdobeStairs, Block pAdobeSlab) {
        return IcariaProcessorLists.erodedVillage(pAdobeBlock, pAdobeStairs, pAdobeSlab, (Block)IcariaBlocks.STRIPPED_POPULUS_LOG.get(), (Block)IcariaBlocks.POPULUS_DECO.stairs.get(), (Block)IcariaBlocks.POPULUS_DECO.slab.get(), IcariaBlocks.SIMPLE_POPULUS_RACK.get(), IcariaBlocks.POPULUS_RACK.get(), IcariaBlocks.POPULUS_BARREL.get(), IcariaBlocks.LOADED_POPULUS_BARREL.get(), IcariaBlocks.TAPPED_POPULUS_BARREL.get(), IcariaBlocks.TRIPLE_POPULUS_BARREL_RACK.get(), IcariaBlocks.POPULUS_WALL_SIGN.get(), IcariaBlocks.FIR_PLANKS.get(), (Block)IcariaBlocks.FIR_DECO.slab.get(), (Block)IcariaBlocks.FIR_DECO.fence.get(), IcariaBlocks.FIR_CRAFTING_TABLE.get(), (Block)IcariaBlocks.FIR_DOOR.get(), (Block)IcariaBlocks.FIR_TRAPDOOR.get(), IcariaBlocks.FIR_LADDER.get());
    }

    public static StructureProcessorList pristineForestVillage(Block pAdobeBlock, Block pAdobeStairs, Block pAdobeSlab) {
        return IcariaProcessorLists.pristineVillage(pAdobeBlock, pAdobeStairs, pAdobeSlab, (Block)IcariaBlocks.STRIPPED_POPULUS_LOG.get(), (Block)IcariaBlocks.POPULUS_DECO.stairs.get(), (Block)IcariaBlocks.POPULUS_DECO.slab.get(), IcariaBlocks.SIMPLE_POPULUS_RACK.get(), IcariaBlocks.POPULUS_RACK.get(), IcariaBlocks.POPULUS_BARREL.get(), IcariaBlocks.LOADED_POPULUS_BARREL.get(), IcariaBlocks.TAPPED_POPULUS_BARREL.get(), IcariaBlocks.TRIPLE_POPULUS_BARREL_RACK.get(), IcariaBlocks.POPULUS_WALL_SIGN.get(), IcariaBlocks.FIR_PLANKS.get(), (Block)IcariaBlocks.FIR_DECO.slab.get(), (Block)IcariaBlocks.FIR_DECO.fence.get(), IcariaBlocks.FIR_CRAFTING_TABLE.get(), (Block)IcariaBlocks.FIR_DOOR.get(), (Block)IcariaBlocks.FIR_TRAPDOOR.get(), IcariaBlocks.FIR_LADDER.get());
    }

    public static StructureProcessorList ruinedForestVillage(Block pAdobeBlock) {
        return IcariaProcessorLists.ruinedVillage(pAdobeBlock);
    }

    public static StructureProcessorList erodedScrublandVillage(Block pAdobeBlock, Block pAdobeStairs, Block pAdobeSlab) {
        return IcariaProcessorLists.erodedVillage(pAdobeBlock, pAdobeStairs, pAdobeSlab, (Block)IcariaBlocks.STRIPPED_LAUREL_LOG.get(), (Block)IcariaBlocks.LAUREL_DECO.stairs.get(), (Block)IcariaBlocks.LAUREL_DECO.slab.get(), IcariaBlocks.SIMPLE_LAUREL_RACK.get(), IcariaBlocks.LAUREL_RACK.get(), IcariaBlocks.LAUREL_BARREL.get(), IcariaBlocks.LOADED_LAUREL_BARREL.get(), IcariaBlocks.TAPPED_LAUREL_BARREL.get(), IcariaBlocks.TRIPLE_LAUREL_BARREL_RACK.get(), IcariaBlocks.LAUREL_WALL_SIGN.get(), IcariaBlocks.PLANE_PLANKS.get(), (Block)IcariaBlocks.PLANE_DECO.slab.get(), (Block)IcariaBlocks.PLANE_DECO.fence.get(), IcariaBlocks.PLANE_CRAFTING_TABLE.get(), (Block)IcariaBlocks.PLANE_DOOR.get(), (Block)IcariaBlocks.PLANE_TRAPDOOR.get(), IcariaBlocks.PLANE_LADDER.get());
    }

    public static StructureProcessorList pristineScrublandVillage(Block pAdobeBlock, Block pAdobeStairs, Block pAdobeSlab) {
        return IcariaProcessorLists.pristineVillage(pAdobeBlock, pAdobeStairs, pAdobeSlab, (Block)IcariaBlocks.STRIPPED_LAUREL_LOG.get(), (Block)IcariaBlocks.LAUREL_DECO.stairs.get(), (Block)IcariaBlocks.LAUREL_DECO.slab.get(), IcariaBlocks.SIMPLE_LAUREL_RACK.get(), IcariaBlocks.LAUREL_RACK.get(), IcariaBlocks.LAUREL_BARREL.get(), IcariaBlocks.LOADED_LAUREL_BARREL.get(), IcariaBlocks.TAPPED_LAUREL_BARREL.get(), IcariaBlocks.TRIPLE_LAUREL_BARREL_RACK.get(), IcariaBlocks.LAUREL_WALL_SIGN.get(), IcariaBlocks.PLANE_PLANKS.get(), (Block)IcariaBlocks.PLANE_DECO.slab.get(), (Block)IcariaBlocks.PLANE_DECO.fence.get(), IcariaBlocks.PLANE_CRAFTING_TABLE.get(), (Block)IcariaBlocks.PLANE_DOOR.get(), (Block)IcariaBlocks.PLANE_TRAPDOOR.get(), IcariaBlocks.PLANE_LADDER.get());
    }

    public static StructureProcessorList ruinedScrublandVillage(Block pAdobeBlock) {
        return IcariaProcessorLists.ruinedVillage(pAdobeBlock);
    }

    public static StructureProcessorList erodedSteppeVillage(Block pAdobeBlock, Block pAdobeStairs, Block pAdobeSlab) {
        return IcariaProcessorLists.erodedVillage(pAdobeBlock, pAdobeStairs, pAdobeSlab, (Block)IcariaBlocks.STRIPPED_CYPRESS_LOG.get(), (Block)IcariaBlocks.CYPRESS_DECO.stairs.get(), (Block)IcariaBlocks.CYPRESS_DECO.slab.get(), IcariaBlocks.SIMPLE_CYPRESS_RACK.get(), IcariaBlocks.CYPRESS_RACK.get(), IcariaBlocks.CYPRESS_BARREL.get(), IcariaBlocks.LOADED_CYPRESS_BARREL.get(), IcariaBlocks.TAPPED_CYPRESS_BARREL.get(), IcariaBlocks.TRIPLE_CYPRESS_BARREL_RACK.get(), IcariaBlocks.CYPRESS_WALL_SIGN.get(), IcariaBlocks.OLIVE_PLANKS.get(), (Block)IcariaBlocks.OLIVE_DECO.slab.get(), (Block)IcariaBlocks.OLIVE_DECO.fence.get(), IcariaBlocks.OLIVE_CRAFTING_TABLE.get(), (Block)IcariaBlocks.OLIVE_DOOR.get(), (Block)IcariaBlocks.OLIVE_TRAPDOOR.get(), IcariaBlocks.OLIVE_LADDER.get());
    }

    public static StructureProcessorList pristineSteppeVillage(Block pAdobeBlock, Block pAdobeStairs, Block pAdobeSlab) {
        return IcariaProcessorLists.pristineVillage(pAdobeBlock, pAdobeStairs, pAdobeSlab, (Block)IcariaBlocks.STRIPPED_CYPRESS_LOG.get(), (Block)IcariaBlocks.CYPRESS_DECO.stairs.get(), (Block)IcariaBlocks.CYPRESS_DECO.slab.get(), IcariaBlocks.SIMPLE_CYPRESS_RACK.get(), IcariaBlocks.CYPRESS_RACK.get(), IcariaBlocks.CYPRESS_BARREL.get(), IcariaBlocks.LOADED_CYPRESS_BARREL.get(), IcariaBlocks.TAPPED_CYPRESS_BARREL.get(), IcariaBlocks.TRIPLE_CYPRESS_BARREL_RACK.get(), IcariaBlocks.CYPRESS_WALL_SIGN.get(), IcariaBlocks.OLIVE_PLANKS.get(), (Block)IcariaBlocks.OLIVE_DECO.slab.get(), (Block)IcariaBlocks.OLIVE_DECO.fence.get(), IcariaBlocks.OLIVE_CRAFTING_TABLE.get(), (Block)IcariaBlocks.OLIVE_DOOR.get(), (Block)IcariaBlocks.OLIVE_TRAPDOOR.get(), IcariaBlocks.OLIVE_LADDER.get());
    }

    public static StructureProcessorList ruinedSteppeVillage(Block pAdobeBlock) {
        return IcariaProcessorLists.ruinedVillage(pAdobeBlock);
    }

    public static StructureProcessorList erodedDesertVillage(Block pAdobeBlock, Block pAdobeStairs, Block pAdobeSlab) {
        return IcariaProcessorLists.erodedVillage(pAdobeBlock, pAdobeStairs, pAdobeSlab, (Block)IcariaBlocks.STRIPPED_CYPRESS_LOG.get(), (Block)IcariaBlocks.CYPRESS_DECO.stairs.get(), (Block)IcariaBlocks.CYPRESS_DECO.slab.get(), IcariaBlocks.SIMPLE_CYPRESS_RACK.get(), IcariaBlocks.CYPRESS_RACK.get(), IcariaBlocks.CYPRESS_BARREL.get(), IcariaBlocks.LOADED_CYPRESS_BARREL.get(), IcariaBlocks.TAPPED_CYPRESS_BARREL.get(), IcariaBlocks.TRIPLE_CYPRESS_BARREL_RACK.get(), IcariaBlocks.CYPRESS_WALL_SIGN.get(), IcariaBlocks.DROUGHTROOT_PLANKS.get(), (Block)IcariaBlocks.DROUGHTROOT_DECO.slab.get(), (Block)IcariaBlocks.DROUGHTROOT_DECO.fence.get(), IcariaBlocks.DROUGHTROOT_CRAFTING_TABLE.get(), (Block)IcariaBlocks.DROUGHTROOT_DOOR.get(), (Block)IcariaBlocks.DROUGHTROOT_TRAPDOOR.get(), IcariaBlocks.DROUGHTROOT_LADDER.get());
    }

    public static StructureProcessorList pristineDesertVillage(Block pAdobeBlock, Block pAdobeStairs, Block pAdobeSlab) {
        return IcariaProcessorLists.pristineVillage(pAdobeBlock, pAdobeStairs, pAdobeSlab, (Block)IcariaBlocks.STRIPPED_CYPRESS_LOG.get(), (Block)IcariaBlocks.CYPRESS_DECO.stairs.get(), (Block)IcariaBlocks.CYPRESS_DECO.slab.get(), IcariaBlocks.SIMPLE_CYPRESS_RACK.get(), IcariaBlocks.CYPRESS_RACK.get(), IcariaBlocks.CYPRESS_BARREL.get(), IcariaBlocks.LOADED_CYPRESS_BARREL.get(), IcariaBlocks.TAPPED_CYPRESS_BARREL.get(), IcariaBlocks.TRIPLE_CYPRESS_BARREL_RACK.get(), IcariaBlocks.CYPRESS_WALL_SIGN.get(), IcariaBlocks.DROUGHTROOT_PLANKS.get(), (Block)IcariaBlocks.DROUGHTROOT_DECO.slab.get(), (Block)IcariaBlocks.DROUGHTROOT_DECO.fence.get(), IcariaBlocks.DROUGHTROOT_CRAFTING_TABLE.get(), (Block)IcariaBlocks.DROUGHTROOT_DOOR.get(), (Block)IcariaBlocks.DROUGHTROOT_TRAPDOOR.get(), IcariaBlocks.DROUGHTROOT_LADDER.get());
    }

    public static StructureProcessorList ruinedDesertVillage(Block pAdobeBlock) {
        return IcariaProcessorLists.ruinedVillage(pAdobeBlock);
    }

    public static StructureProcessorList erodedVillage(Block pAdobeBlock, Block pAdobeStairs, Block pAdobeSlab, Block pStrippedLog, Block pLaurelStairs, Block pLaurelSlab, Block pSimpleRack, Block pRack, Block pBarrel, Block pLoadedBarrel, Block pTappedBarrel, Block pTripleBarrel, Block pWallSign, Block pPlanePlanks, Block pPlaneSlab, Block pPlaneFence, Block pCraftingTable, Block pDoor, Block pTrapdoor, Block pLadder) {
        return new StructureProcessorList((List)ImmutableList.of((Object)IcariaProcessorLists.block(IcariaBlocks.YELLOWSTONE_ADOBE.get(), pAdobeBlock), (Object)IcariaProcessorLists.stairs((Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.stairs.get(), pAdobeStairs), (Object)IcariaProcessorLists.slab((Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.slab.get(), pAdobeSlab), (Object)IcariaProcessorLists.block(IcariaBlocks.RELICSTONE_TILES.get(), 0.25f, IcariaBlocks.CRACKED_RELICSTONE_TILES.get(), 0.25f, IcariaBlocks.MOSSY_RELICSTONE_TILES.get()), (Object)IcariaProcessorLists.stairs((Block)IcariaBlocks.RELICSTONE_TILE_DECO.stairs.get(), 0.25f, (Block)IcariaBlocks.CRACKED_RELICSTONE_TILE_DECO.stairs.get(), 0.25f, (Block)IcariaBlocks.MOSSY_RELICSTONE_TILE_DECO.stairs.get()), (Object)IcariaProcessorLists.block(IcariaBlocks.RED_LOOT_VASE.get(), 0.25f, IcariaBlocks.REVENANT_SPAWNER.get(), 0.5f, Blocks.AIR), (Object)IcariaProcessorLists.log((Block)IcariaBlocks.STRIPPED_LAUREL_LOG.get(), pStrippedLog), (Object)IcariaProcessorLists.stairs((Block)IcariaBlocks.LAUREL_DECO.stairs.get(), pLaurelStairs), (Object)IcariaProcessorLists.slab((Block)IcariaBlocks.LAUREL_DECO.slab.get(), pLaurelSlab), (Object)IcariaProcessorLists.rack(IcariaBlocks.SIMPLE_LAUREL_RACK.get(), pSimpleRack), (Object)IcariaProcessorLists.rack(IcariaBlocks.LAUREL_RACK.get(), pRack), (Object)IcariaProcessorLists.barrel(IcariaBlocks.LAUREL_BARREL.get(), pBarrel), (Object[])new StructureProcessor[]{IcariaProcessorLists.barrel(IcariaBlocks.LOADED_LAUREL_BARREL.get(), pLoadedBarrel), IcariaProcessorLists.barrel(IcariaBlocks.TAPPED_LAUREL_BARREL.get(), pTappedBarrel), IcariaProcessorLists.tripleBarrel(IcariaBlocks.TRIPLE_LAUREL_BARREL_RACK.get(), pTripleBarrel), IcariaProcessorLists.wallSign(IcariaBlocks.LAUREL_WALL_SIGN.get(), pWallSign), IcariaProcessorLists.block(IcariaBlocks.PLANE_PLANKS.get(), pPlanePlanks), IcariaProcessorLists.slab((Block)IcariaBlocks.PLANE_DECO.slab.get(), pPlaneSlab), IcariaProcessorLists.fence((Block)IcariaBlocks.PLANE_DECO.fence.get(), pPlaneFence), IcariaProcessorLists.block(IcariaBlocks.PLANE_CRAFTING_TABLE.get(), pCraftingTable), IcariaProcessorLists.door((Block)IcariaBlocks.PLANE_DOOR.get(), pDoor), IcariaProcessorLists.trapdoor((Block)IcariaBlocks.PLANE_TRAPDOOR.get(), pTrapdoor), IcariaProcessorLists.ladder(IcariaBlocks.PLANE_LADDER.get(), pLadder)}));
    }

    public static StructureProcessorList pristineVillage(Block pAdobeBlock, Block pAdobeStairs, Block pAdobeSlab, Block pStrippedLog, Block pLaurelStairs, Block pLaurelSlab, Block pSimpleRack, Block pRack, Block pBarrel, Block pLoadedBarrel, Block pTappedBarrel, Block pTripleBarrel, Block pWallSign, Block pPlanePlanks, Block pPlaneSlab, Block pPlaneFence, Block pCraftingTable, Block pDoor, Block pTrapdoor, Block pLadder) {
        return new StructureProcessorList((List)ImmutableList.of((Object)IcariaProcessorLists.block(IcariaBlocks.YELLOWSTONE_ADOBE.get(), pAdobeBlock), (Object)IcariaProcessorLists.stairs((Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.stairs.get(), pAdobeStairs), (Object)IcariaProcessorLists.slab((Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.slab.get(), pAdobeSlab), (Object)IcariaProcessorLists.block(IcariaBlocks.RED_LOOT_VASE.get(), 0.66f, Blocks.AIR), (Object)IcariaProcessorLists.log((Block)IcariaBlocks.STRIPPED_LAUREL_LOG.get(), pStrippedLog), (Object)IcariaProcessorLists.stairs((Block)IcariaBlocks.LAUREL_DECO.stairs.get(), pLaurelStairs), (Object)IcariaProcessorLists.slab((Block)IcariaBlocks.LAUREL_DECO.slab.get(), pLaurelSlab), (Object)IcariaProcessorLists.rack(IcariaBlocks.SIMPLE_LAUREL_RACK.get(), pSimpleRack), (Object)IcariaProcessorLists.rack(IcariaBlocks.LAUREL_RACK.get(), pRack), (Object)IcariaProcessorLists.barrel(IcariaBlocks.LAUREL_BARREL.get(), pBarrel), (Object)IcariaProcessorLists.barrel(IcariaBlocks.LOADED_LAUREL_BARREL.get(), pLoadedBarrel), (Object)IcariaProcessorLists.barrel(IcariaBlocks.TAPPED_LAUREL_BARREL.get(), pTappedBarrel), (Object[])new StructureProcessor[]{IcariaProcessorLists.tripleBarrel(IcariaBlocks.TRIPLE_LAUREL_BARREL_RACK.get(), pTripleBarrel), IcariaProcessorLists.wallSign(IcariaBlocks.LAUREL_WALL_SIGN.get(), pWallSign), IcariaProcessorLists.block(IcariaBlocks.PLANE_PLANKS.get(), pPlanePlanks), IcariaProcessorLists.slab((Block)IcariaBlocks.PLANE_DECO.slab.get(), pPlaneSlab), IcariaProcessorLists.fence((Block)IcariaBlocks.PLANE_DECO.fence.get(), pPlaneFence), IcariaProcessorLists.block(IcariaBlocks.PLANE_CRAFTING_TABLE.get(), pCraftingTable), IcariaProcessorLists.door((Block)IcariaBlocks.PLANE_DOOR.get(), pDoor), IcariaProcessorLists.trapdoor((Block)IcariaBlocks.PLANE_TRAPDOOR.get(), pTrapdoor), IcariaProcessorLists.ladder(IcariaBlocks.PLANE_LADDER.get(), pLadder)}));
    }

    public static StructureProcessorList ruinedVillage(Block pAdobeBlock) {
        return new StructureProcessorList((List)ImmutableList.of((Object)IcariaProcessorLists.block(Blocks.CHISELED_BOOKSHELF, Blocks.AIR), (Object)IcariaProcessorLists.block(Blocks.COMPOSTER, Blocks.AIR), (Object)IcariaProcessorLists.block(Blocks.GRAY_CONCRETE, Blocks.AIR), (Object)IcariaProcessorLists.block(Blocks.PINK_CONCRETE, Blocks.AIR), (Object)IcariaProcessorLists.block(IcariaBlocks.SURFACE_LIGNITE.get(), Blocks.AIR), (Object)IcariaProcessorLists.block(IcariaBlocks.GRAINITE_BRICKS.get(), Blocks.AIR), (Object)IcariaProcessorLists.block((Block)IcariaBlocks.GRAINITE_BRICK_DECO.stairs.get(), Blocks.AIR), (Object)IcariaProcessorLists.block(IcariaBlocks.YELLOWSTONE_ADOBE.get(), pAdobeBlock), (Object)IcariaProcessorLists.block((Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.stairs.get(), Blocks.AIR), (Object)IcariaProcessorLists.block((Block)IcariaBlocks.YELLOWSTONE_ADOBE_DECO.slab.get(), Blocks.AIR), (Object)IcariaProcessorLists.block(pAdobeBlock, 0.25f, Blocks.COBWEB, 0.25f, Blocks.AIR, Direction.Axis.Y), (Object)IcariaProcessorLists.block(IcariaBlocks.RELICSTONE_TILES.get(), 0.25f, Blocks.COBWEB, 0.25f, Blocks.AIR, Direction.Axis.Y), (Object[])new StructureProcessor[]{IcariaProcessorLists.block(IcariaBlocks.RELICSTONE_TILES.get(), 0.5f, IcariaBlocks.CRACKED_RELICSTONE_TILES.get(), 0.5f, IcariaBlocks.MOSSY_RELICSTONE_TILES.get()), IcariaProcessorLists.block((Block)IcariaBlocks.RELICSTONE_TILE_DECO.stairs.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.CHEST.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.RED_LOOT_VASE.get(), 0.25f, IcariaBlocks.ARACHNE_SPAWNER.get(), 0.5f, Blocks.AIR), IcariaProcessorLists.block((Block)IcariaBlocks.STRIPPED_LAUREL_LOG.get(), Blocks.AIR), IcariaProcessorLists.block((Block)IcariaBlocks.LAUREL_DECO.stairs.get(), Blocks.AIR), IcariaProcessorLists.block((Block)IcariaBlocks.LAUREL_DECO.slab.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.SIMPLE_LAUREL_RACK.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.LAUREL_RACK.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.LAUREL_BARREL.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.LOADED_LAUREL_BARREL.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.TAPPED_LAUREL_BARREL.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.TRIPLE_LAUREL_BARREL_RACK.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.LAUREL_WALL_SIGN.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.PLANE_PLANKS.get(), Blocks.AIR), IcariaProcessorLists.block((Block)IcariaBlocks.PLANE_DECO.slab.get(), Blocks.AIR), IcariaProcessorLists.block((Block)IcariaBlocks.PLANE_DECO.fence.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.PLANE_CRAFTING_TABLE.get(), Blocks.AIR), IcariaProcessorLists.block((Block)IcariaBlocks.PLANE_DOOR.get(), Blocks.AIR), IcariaProcessorLists.block((Block)IcariaBlocks.PLANE_TRAPDOOR.get(), Blocks.AIR), IcariaProcessorLists.block(IcariaBlocks.PLANE_LADDER.get(), Blocks.AIR)}));
    }

    public static RuleProcessor block(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(pOld), (RuleTest)AlwaysTrueTest.INSTANCE, pNew.defaultBlockState())));
    }

    public static RuleProcessor block(Block pOld, Block pNew, Direction.Axis pAxis) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(pOld), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)new AxisAlignedLinearPosTest(0.0f, 1.0f, 0, 8, pAxis), pNew.defaultBlockState())));
    }

    public static RuleProcessor block(Block pOld, float pChance, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChance), (RuleTest)AlwaysTrueTest.INSTANCE, pNew.defaultBlockState())));
    }

    public static RuleProcessor block(Block pOld, float pChance, Block pNew, Direction.Axis pAxis) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChance), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)new AxisAlignedLinearPosTest(0.0f, 1.0f, 0, 8, pAxis), pNew.defaultBlockState())));
    }

    public static RuleProcessor block(Block pOld, float pChanceA, Block pNewA, float pChanceB, Block pNewB) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, pNewA.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, pNewB.defaultBlockState())));
    }

    public static RuleProcessor block(Block pOld, float pChanceA, Block pNewA, float pChanceB, Block pNewB, Direction.Axis pAxis) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)new AxisAlignedLinearPosTest(0.0f, 1.0f, 0, 8, pAxis), pNewA.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)new AxisAlignedLinearPosTest(0.0f, 1.0f, 0, 8, pAxis), pNewB.defaultBlockState())));
    }

    public static RuleProcessor block(Block pOld, float pChanceA, Block pNewA, float pChanceB, Block pNewB, float pChanceC, Block pNewC) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, pNewA.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, pNewB.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChanceC), (RuleTest)AlwaysTrueTest.INSTANCE, pNewC.defaultBlockState())));
    }

    public static RuleProcessor block(Block pOld, float pChanceA, Block pNewA, float pChanceB, Block pNewB, float pChanceC, Block pNewC, Direction.Axis pAxis) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)new AxisAlignedLinearPosTest(0.0f, 1.0f, 0, 8, pAxis), pNewA.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)new AxisAlignedLinearPosTest(0.0f, 1.0f, 0, 8, pAxis), pNewB.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest(pOld.defaultBlockState(), pChanceC), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)new AxisAlignedLinearPosTest(0.0f, 1.0f, 0, 8, pAxis), pNewC.defaultBlockState())));
    }

    public static RuleProcessor stairs(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (Object[])new ProcessorRule[]{new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT))}));
    }

    public static RuleProcessor stairs(Block pOld, float pChanceA, Block pNewA, float pChanceB, Block pNewB) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), (Object[])new ProcessorRule[]{new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.INNER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_LEFT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT)), new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.OUTER_RIGHT))}));
    }

    public static RuleProcessor slab(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE))));
    }

    public static RuleProcessor slab(Block pOld, float pChanceA, Block pNewA, float pChanceB, Block pNewB) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE), pChanceA), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNewA.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM)), (Object)new ProcessorRule((RuleTest)new RandomBlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE), pChanceB), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNewB.defaultBlockState().setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE))));
    }

    public static RuleProcessor log(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z))));
    }

    public static RuleProcessor rack(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(true))), (Object[])new ProcessorRule[]{new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(true))), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(true))), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(true))), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(true)))}));
    }

    public static RuleProcessor barrel(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.UP)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.UP)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.UP)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.UP)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.UP)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.UP)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.UP)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.UP)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.NORTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.NORTH)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.NORTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.NORTH)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.NORTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.NORTH)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.NORTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.NORTH)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.EAST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.EAST)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.EAST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.EAST)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.EAST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.EAST)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.EAST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.EAST)), (Object[])new ProcessorRule[]{new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.SOUTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.SOUTH)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.SOUTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.SOUTH)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.SOUTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.SOUTH)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.SOUTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.SOUTH)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.WEST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.WEST)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.WEST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.WEST)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.WEST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.WEST)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.WEST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.WEST))}));
    }

    public static RuleProcessor tripleBarrel(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_LEFT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_LEFT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_LEFT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_LEFT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_LEFT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_LEFT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_LEFT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_LEFT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_RIGHT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_RIGHT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_RIGHT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_RIGHT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_RIGHT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_RIGHT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_RIGHT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_RIGHT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_LEFT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_LEFT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_LEFT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_LEFT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_LEFT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_LEFT))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_LEFT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_LEFT))), (Object[])new ProcessorRule[]{new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_RIGHT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_RIGHT))), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_RIGHT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_RIGHT))), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_RIGHT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_RIGHT))), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_RIGHT))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_RIGHT)))}));
    }

    public static RuleProcessor wallSign(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.CEILING)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.CEILING)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.CEILING)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.CEILING)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.CEILING)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.CEILING)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.CEILING)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.CEILING)), (Object[])new ProcessorRule[0]));
    }

    public static RuleProcessor fence(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest(pOld.defaultBlockState()), (RuleTest)AlwaysTrueTest.INSTANCE, pNew.defaultBlockState()), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))), (Object[])new ProcessorRule[]{new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true)))}));
    }

    public static RuleProcessor door(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.LEFT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (Object[])new ProcessorRule[]{new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.DOOR_HINGE, (Comparable)DoorHingeSide.RIGHT))}));
    }

    public static RuleProcessor trapdoor(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM))));
    }

    public static RuleProcessor ladder(Block pOld, Block pNew) {
        return new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)), (Object)new ProcessorRule((RuleTest)new BlockStateMatchTest((BlockState)pOld.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)), (RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)pNew.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST))));
    }

    public static ResourceKey<StructureProcessorList> createKey(String pName) {
        return ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"landsoficaria", (String)pName));
    }
}

