/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.registry;

import com.axanthic.icaria.common.registry.IcariaBiomes;
import com.axanthic.icaria.common.registry.IcariaTemplatePools;
import com.axanthic.icaria.common.world.structure.IcariaJigsawStructure;
import com.axanthic.icaria.data.tags.IcariaBiomeTags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaStructures {
    public static final ResourceKey<Structure> PORTAL_ICARIA = IcariaStructures.createKey("portal/icaria");
    public static final ResourceKey<Structure> PORTAL_NETHER = IcariaStructures.createKey("portal/nether");
    public static final ResourceKey<Structure> RUIN = IcariaStructures.createKey("ruin");
    public static final ResourceKey<Structure> TEMPLE = IcariaStructures.createKey("temple");
    public static final ResourceKey<Structure> ERODED_FOREST_VILLAGE = IcariaStructures.createKey("villages/forest/eroded");
    public static final ResourceKey<Structure> PRISTINE_FOREST_VILLAGE = IcariaStructures.createKey("villages/forest/pristine");
    public static final ResourceKey<Structure> RUINED_FOREST_VILLAGE = IcariaStructures.createKey("villages/forest/ruined");
    public static final ResourceKey<Structure> ERODED_SCRUBLAND_VILLAGE = IcariaStructures.createKey("villages/scrubland/eroded");
    public static final ResourceKey<Structure> PRISTINE_SCRUBLAND_VILLAGE = IcariaStructures.createKey("villages/scrubland/pristine");
    public static final ResourceKey<Structure> RUINED_SCRUBLAND_VILLAGE = IcariaStructures.createKey("villages/scrubland/ruined");
    public static final ResourceKey<Structure> ERODED_STEPPE_VILLAGE = IcariaStructures.createKey("villages/steppe/eroded");
    public static final ResourceKey<Structure> PRISTINE_STEPPE_VILLAGE = IcariaStructures.createKey("villages/steppe/pristine");
    public static final ResourceKey<Structure> RUINED_STEPPE_VILLAGE = IcariaStructures.createKey("villages/steppe/ruined");
    public static final ResourceKey<Structure> ERODED_DESERT_VILLAGE = IcariaStructures.createKey("villages/desert/eroded");
    public static final ResourceKey<Structure> PRISTINE_DESERT_VILLAGE = IcariaStructures.createKey("villages/desert/pristine");
    public static final ResourceKey<Structure> RUINED_DESERT_VILLAGE = IcariaStructures.createKey("villages/desert/ruined");

    public static void bootstrap(BootstrapContext<Structure> pContext) {
        HolderGetter biomes = pContext.lookup(Registries.BIOME);
        HolderGetter pools = pContext.lookup(Registries.TEMPLATE_POOL);
        pContext.register(PORTAL_ICARIA, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(IcariaBiomeTags.IS_SURFACE), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.PORTAL_ICARIA), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(PORTAL_NETHER, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(IcariaBiomeTags.HAS_PORTAL), Map.of(), GenerationStep.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.PORTAL_NETHER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)32)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(RUIN, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(IcariaBiomeTags.IS_LOST), Map.of(), GenerationStep.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.RUIN_BUILDING), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)40)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)48)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(TEMPLE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(IcariaBiomeTags.IS_SURFACE), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.TEMPLE_HALL), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(ERODED_FOREST_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.FOREST)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.ERODED_FOREST_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(PRISTINE_FOREST_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.FOREST)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.PRISTINE_FOREST_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(RUINED_FOREST_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.FOREST)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.RUINED_FOREST_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(ERODED_SCRUBLAND_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.SCRUBLAND)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.ERODED_SCRUBLAND_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(PRISTINE_SCRUBLAND_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.SCRUBLAND)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.PRISTINE_SCRUBLAND_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(RUINED_SCRUBLAND_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.SCRUBLAND)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.RUINED_SCRUBLAND_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(ERODED_STEPPE_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.STEPPE)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.ERODED_STEPPE_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(PRISTINE_STEPPE_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.STEPPE)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.PRISTINE_STEPPE_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(RUINED_STEPPE_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.STEPPE)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.RUINED_STEPPE_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(ERODED_DESERT_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.DESERT)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.ERODED_DESERT_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(PRISTINE_DESERT_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.DESERT)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.PRISTINE_DESERT_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
        pContext.register(RUINED_DESERT_VILLAGE, (Object)new IcariaJigsawStructure(new Structure.StructureSettings((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(IcariaBiomes.DESERT)}), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(IcariaTemplatePools.RUINED_DESERT_VILLAGE_CENTER), Optional.empty(), 16, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)88)), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)96)), false, Optional.empty(), 128, List.of(), DimensionPadding.ZERO, LiquidSettings.APPLY_WATERLOGGING));
    }

    public static ResourceKey<Structure> createKey(String pName) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"landsoficaria", (String)pName));
    }
}

