/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.registry;

import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.registries.DeferredRegister;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaWoodDecoBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"landsoficaria");
    public String name;
    public Supplier<Block> block;
    public Supplier<StairBlock> stairs;
    public Supplier<SlabBlock> slab;
    public Supplier<FenceBlock> fence;
    public Supplier<FenceGateBlock> gate;

    public IcariaWoodDecoBlocks(String pName, Supplier<Block> pBlock, WoodType pType, BlockBehaviour.Properties pProperties, boolean pStairs, boolean pSlab, boolean pFence, boolean pGate) {
        this.name = pName;
        this.block = pBlock;
        this.stairs = BLOCKS.register(pName + "_stairs", () -> new StairBlock(((Block)pBlock.get()).defaultBlockState(), pProperties));
        this.slab = BLOCKS.register(pName + "_slab", () -> new SlabBlock(pProperties));
        this.fence = BLOCKS.register(pName + "_fence", () -> new FenceBlock(pProperties));
        this.gate = BLOCKS.register(pName + "_fence_gate", () -> new FenceGateBlock(pType, pProperties));
    }

    public IcariaWoodDecoBlocks(String pName, Supplier<Block> pBlock, WoodType pType, BlockBehaviour.Properties pProperties) {
        this(pName, pBlock, pType, pProperties, true, true, true, true);
    }
}

