/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.util;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.portal.PortalShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaPortalShape
extends PortalShape {
    public int height;
    public int minHeight = 2;
    public int maxHeight = 21;
    public int width;
    public int minWidth = 1;
    public int maxWidth = 21;
    public int numPortalBlocks;
    public BlockPos bottomLeft;
    public Direction leftDir;
    public Direction rightDir;
    public Direction.Axis axis;
    public LevelAccessor level;

    public IcariaPortalShape(LevelAccessor pLevel, BlockPos pPos, Direction.Axis pAxis) {
        super(pLevel, pPos, pAxis);
        this.axis = pAxis;
        this.level = pLevel;
        if (pAxis == Direction.Axis.X) {
            this.leftDir = Direction.EAST;
            this.rightDir = Direction.WEST;
        } else {
            this.leftDir = Direction.NORTH;
            this.rightDir = Direction.SOUTH;
        }
        int i = this.getDistanceUntilEdgeAboveFrame(pPos, this.leftDir) - 1;
        if (i >= 0) {
            this.bottomLeft = pPos.relative(this.leftDir, i);
            this.width = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
            if (this.width < this.minWidth || this.width > this.maxWidth) {
                this.bottomLeft = null;
                this.width = 0;
            }
        }
        if (this.bottomLeft != null) {
            this.height = this.calculateHeight();
        }
    }

    public boolean isComplete() {
        return this.isValid() && this.height * this.width == this.numPortalBlocks;
    }

    public boolean isEmpty(BlockState pState) {
        return !pState.canBeReplaced() && !pState.is(IcariaBlocks.GREEK_FIRE.get());
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.height >= this.minHeight && this.height <= this.maxHeight && this.width >= this.minWidth && this.width <= this.maxWidth;
    }

    public int calculateHeight() {
        int w;
        BlockPos blockPos;
        this.height = 0;
        block0: while (this.height <= this.maxHeight) {
            for (int i = 0; i < this.width; ++i) {
                blockPos = this.bottomLeft.relative(this.rightDir, i).above(this.height);
                BlockState blockState = this.level.getBlockState(blockPos);
                if (this.isEmpty(blockState)) break block0;
                Block block = blockState.getBlock();
                if (block != IcariaBlocks.ICARIA_PORTAL.get()) continue;
                ++this.numPortalBlocks;
            }
            ++this.height;
        }
        block2: for (int h = 0; h < this.height - 1; ++h) {
            BlockPos blockPos2;
            int w2;
            for (w2 = -1; w2 < 0; ++w2) {
                blockPos2 = this.bottomLeft.relative(this.rightDir, w2).above(h);
                if (this.level.getBlockState(blockPos2).equals(Blocks.QUARTZ_PILLAR.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y)) || this.level.getBlockState(blockPos2).equals(IcariaBlocks.DOLOMITE_PILLAR.get().defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y))) continue;
                this.height = 0;
                break;
            }
            for (w2 = this.width; w2 < this.width + 1; ++w2) {
                blockPos2 = this.bottomLeft.relative(this.rightDir, w2).above(h);
                if (this.level.getBlockState(blockPos2).equals(Blocks.QUARTZ_PILLAR.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y)) || this.level.getBlockState(blockPos2).equals(IcariaBlocks.DOLOMITE_PILLAR.get().defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y))) continue;
                this.height = 0;
                continue block2;
            }
        }
        for (w = -1; w < 0; ++w) {
            blockPos = this.bottomLeft.relative(this.rightDir, w).above(this.height - 1);
            if (this.level.getBlockState(blockPos).equals(IcariaBlocks.QUARTZ_PILLAR_HEAD.get().defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN)) || this.level.getBlockState(blockPos).equals(IcariaBlocks.DOLOMITE_PILLAR_HEAD.get().defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN))) continue;
            this.height = 0;
            break;
        }
        for (w = this.width; w < this.width + 1; ++w) {
            blockPos = this.bottomLeft.relative(this.rightDir, w).above(this.height - 1);
            if (this.level.getBlockState(blockPos).equals(IcariaBlocks.QUARTZ_PILLAR_HEAD.get().defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN)) || this.level.getBlockState(blockPos).equals(IcariaBlocks.DOLOMITE_PILLAR_HEAD.get().defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN))) continue;
            this.height = 0;
            break;
        }
        for (w = -1; w < 1; ++w) {
            blockPos = this.bottomLeft.relative(this.rightDir, w).above(this.height);
            if (this.level.getBlockState(blockPos).equals(Blocks.QUARTZ_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM)) || this.level.getBlockState(blockPos).equals(Blocks.SMOOTH_QUARTZ_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM)) || this.level.getBlockState(blockPos).equals(IcariaBlocks.SMOOTH_DOLOMITE_DECO.slab.get().defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM))) continue;
            this.height = 0;
            break;
        }
        for (w = this.width - 1; w < this.width + 1; ++w) {
            blockPos = this.bottomLeft.relative(this.rightDir, w).above(this.height);
            if (this.level.getBlockState(blockPos).equals(Blocks.QUARTZ_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM)) || this.level.getBlockState(blockPos).equals(Blocks.SMOOTH_QUARTZ_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM)) || this.level.getBlockState(blockPos).equals(IcariaBlocks.SMOOTH_DOLOMITE_DECO.slab.get().defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM))) continue;
            this.height = 0;
            break;
        }
        for (w = -2; w < -1; ++w) {
            blockPos = this.bottomLeft.relative(this.rightDir, w).above(this.height - 1);
            if (this.level.getBlockState(blockPos).equals(Blocks.QUARTZ_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP)) || this.level.getBlockState(blockPos).equals(Blocks.SMOOTH_QUARTZ_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP)) || this.level.getBlockState(blockPos).equals(IcariaBlocks.SMOOTH_DOLOMITE_DECO.slab.get().defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP))) continue;
            this.height = 0;
            break;
        }
        for (w = this.width + 1; w < this.width + 2; ++w) {
            blockPos = this.bottomLeft.relative(this.rightDir, w).above(this.height - 1);
            if (this.level.getBlockState(blockPos).equals(Blocks.QUARTZ_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP)) || this.level.getBlockState(blockPos).equals(Blocks.SMOOTH_QUARTZ_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP)) || this.level.getBlockState(blockPos).equals(IcariaBlocks.SMOOTH_DOLOMITE_DECO.slab.get().defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP))) continue;
            this.height = 0;
            break;
        }
        if (this.height >= this.minHeight && this.height <= this.maxHeight) {
            return this.height;
        }
        this.bottomLeft = null;
        this.height = 0;
        this.width = 0;
        return 0;
    }

    public int getDistanceUntilEdgeAboveFrame(BlockPos pPos, Direction pDirection) {
        BlockPos blockPos;
        int i;
        for (i = 0; i <= this.maxWidth && !this.isEmpty(this.level.getBlockState(blockPos = pPos.relative(pDirection, i))) && this.level.getBlockState(blockPos.below()).isFaceSturdy((BlockGetter)this.level, blockPos.below(), Direction.UP); ++i) {
        }
        blockPos = pPos.relative(pDirection, i);
        return this.level.getBlockState(blockPos).is(IcariaBlockTags.PORTAL_BLOCKS) ? i : 0;
    }

    public void createPortalBlocks() {
        for (int w = 0; w < this.width; ++w) {
            BlockPos blockPos = this.bottomLeft.relative(this.rightDir, w);
            for (int h = 0; h < this.height; ++h) {
                this.level.setBlock(blockPos.above(h), (BlockState)IcariaBlocks.ICARIA_PORTAL.get().defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)this.axis), 18);
            }
        }
    }
}

