/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CardonCactusFeature
extends Feature<NoneFeatureConfiguration> {
    public CardonCactusFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        this.placeArm(level, origin, direction, 1, 2);
        this.placeArm(level, origin, direction.getClockWise(), 1, 2);
        this.placeArm(level, origin, direction.getOpposite(), 1, 2);
        this.placeArm(level, origin, direction.getCounterClockWise(), 1, 2);
        this.placeArm(level, origin, direction, 2, 8);
        this.placeArm(level, origin, direction.getClockWise(), 2, 8);
        this.placeArm(level, origin, direction.getOpposite(), 2, 8);
        this.placeArm(level, origin, direction.getCounterClockWise(), 2, 8);
        this.placeTrunk(level, origin, 0);
        this.placeTrunk(level, origin, 1);
        this.placeTrunk(level, origin, 2);
        this.placeTrunk(level, origin, 3);
        this.placeCactus(level, origin.above(4), (BlockState)IcariaBlocks.CARDON_CACTUS.get().defaultBlockState().setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true)));
        return true;
    }

    public void placeArm(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection, int pOffset, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeArm(pLevel, pPos, pDirection, pOffset);
        }
    }

    public void placeArm(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection, int pOffset) {
        BlockPos posOx = pPos.above(pOffset).relative(pDirection);
        BlockPos posOy = pPos.above(pOffset + 1).relative(pDirection);
        boolean check = pLevel.getBlockState(posOx.below()).is(BlockTags.SAND);
        if (pLevel.getBlockState(posOx).isAir() && pLevel.getBlockState(posOy).isAir()) {
            this.placeCactus(pLevel, posOx, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)IcariaBlocks.CARDON_CACTUS.get().defaultBlockState().setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(check))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(pDirection.equals((Object)Direction.SOUTH) && !check))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(pDirection.equals((Object)Direction.WEST) && !check))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(pDirection.equals((Object)Direction.NORTH) && !check))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(pDirection.equals((Object)Direction.EAST) && !check)));
            this.placeCactus(pLevel, posOy, (BlockState)IcariaBlocks.CARDON_CACTUS.get().defaultBlockState().setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void placeTrunk(WorldGenLevel pLevel, BlockPos pPos, int pOffset, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeTrunk(pLevel, pPos, pOffset);
        }
    }

    public void placeTrunk(WorldGenLevel pLevel, BlockPos pPos, int pOffset) {
        boolean checkN = !pLevel.getBlockState(pPos.above(pOffset).below()).is(BlockTags.SAND) && !pLevel.getBlockState(pPos.above(pOffset).below()).is(IcariaBlocks.CARDON_CACTUS.get()) && pLevel.getBlockState(pPos.above(pOffset).north()).is(IcariaBlocks.CARDON_CACTUS.get());
        boolean checkBelowN = !pLevel.getBlockState(pPos.above(pOffset).below().north()).is(BlockTags.SAND) && !pLevel.getBlockState(pPos.above(pOffset).below().north()).is(IcariaBlocks.CARDON_CACTUS.get()) && pLevel.getBlockState(pPos.above(pOffset).north()).is(IcariaBlocks.CARDON_CACTUS.get());
        boolean checkE = !pLevel.getBlockState(pPos.above(pOffset).below()).is(BlockTags.SAND) && !pLevel.getBlockState(pPos.above(pOffset).below()).is(IcariaBlocks.CARDON_CACTUS.get()) && pLevel.getBlockState(pPos.above(pOffset).east()).is(IcariaBlocks.CARDON_CACTUS.get());
        boolean checkBelowE = !pLevel.getBlockState(pPos.above(pOffset).below().east()).is(BlockTags.SAND) && !pLevel.getBlockState(pPos.above(pOffset).below().east()).is(IcariaBlocks.CARDON_CACTUS.get()) && pLevel.getBlockState(pPos.above(pOffset).east()).is(IcariaBlocks.CARDON_CACTUS.get());
        boolean checkS = !pLevel.getBlockState(pPos.above(pOffset).below().south()).is(BlockTags.SAND) && !pLevel.getBlockState(pPos.above(pOffset).below().south()).is(IcariaBlocks.CARDON_CACTUS.get()) && pLevel.getBlockState(pPos.above(pOffset).south()).is(IcariaBlocks.CARDON_CACTUS.get());
        boolean checkBelowS = !pLevel.getBlockState(pPos.above(pOffset).below()).is(BlockTags.SAND) && !pLevel.getBlockState(pPos.above(pOffset).below()).is(IcariaBlocks.CARDON_CACTUS.get()) && pLevel.getBlockState(pPos.above(pOffset).south()).is(IcariaBlocks.CARDON_CACTUS.get());
        boolean checkW = !pLevel.getBlockState(pPos.above(pOffset).below().west()).is(BlockTags.SAND) && !pLevel.getBlockState(pPos.above(pOffset).below().west()).is(IcariaBlocks.CARDON_CACTUS.get()) && pLevel.getBlockState(pPos.above(pOffset).west()).is(IcariaBlocks.CARDON_CACTUS.get());
        boolean checkBelowW = !pLevel.getBlockState(pPos.above(pOffset).below()).is(BlockTags.SAND) && !pLevel.getBlockState(pPos.above(pOffset).below()).is(IcariaBlocks.CARDON_CACTUS.get()) && pLevel.getBlockState(pPos.above(pOffset).west()).is(IcariaBlocks.CARDON_CACTUS.get());
        this.placeCactus(pLevel, pPos.above(pOffset), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)IcariaBlocks.CARDON_CACTUS.get().defaultBlockState().setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(checkN || checkBelowN))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(checkE || checkBelowE))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(checkS || checkBelowS))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(checkW || checkBelowW)));
    }

    public void placeCactus(WorldGenLevel pLevel, BlockPos pPos, BlockState pState, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeCactus(pLevel, pPos, pState);
        }
    }

    public void placeCactus(WorldGenLevel pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.getBlockState(pPos).isAir()) {
            this.setBlock((LevelWriter)pLevel, pPos, pState);
        }
    }
}

