/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature;

import com.axanthic.icaria.common.entity.IcariaSpawnerBlockEntity;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RuinFeature
extends Feature<NoneFeatureConfiguration> {
    public ArrayList<EntityType<?>> mobs = new ArrayList();

    public RuinFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        this.setMobs();
        for (int x = 0; x < 16; ++x) {
            int pX = origin.getX() + x;
            for (int z = 0; z < 16; ++z) {
                int pZ = origin.getZ() + z;
                for (int y = 40; y < 48; ++y) {
                    BlockPos blockPos = new BlockPos(pX, y, pZ);
                    BlockPos belowPos = new BlockPos(pX, y, pZ).below();
                    BlockState oldState = level.getBlockState(belowPos);
                    BlockState newState = oldState.is(IcariaBlocks.MARL.get()) ? IcariaBlocks.GRASSY_MARL.get().defaultBlockState() : oldState;
                    this.replaceRelicstone(level, blockPos, newState, 10);
                    this.setMobsForSpawners(level, blockPos, random);
                }
            }
        }
        return true;
    }

    public void replaceRelicstone(WorldGenLevel pLevel, BlockPos pPos, BlockState pState, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.replaceRelicstone(pLevel, pPos, pState);
        }
    }

    public void replaceRelicstone(WorldGenLevel pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.getBlockState(pPos).is(IcariaBlocks.RELICSTONE.get())) {
            this.setBlock((LevelWriter)pLevel, pPos, pState);
        }
    }

    public void setMobsForSpawners(WorldGenLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof IcariaSpawnerBlockEntity) {
            IcariaSpawnerBlockEntity blockEntity2 = (IcariaSpawnerBlockEntity)blockEntity;
            blockEntity2.setEntityId(this.getMob(pRandom), pRandom);
        }
    }

    public void setMobs() {
        this.mobs.add(IcariaEntityTypes.CIVILIAN_REVENANT.get());
        this.mobs.add(IcariaEntityTypes.PYROMANCER_REVENANT.get());
        this.mobs.add(IcariaEntityTypes.SOLDIER_REVENANT.get());
    }

    public EntityType<?> getMob(RandomSource pRandom) {
        return this.mobs.get(pRandom.nextInt(this.mobs.size()));
    }
}

