/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature;

import com.axanthic.icaria.common.properties.Ripe;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StrawberryBushFeature
extends Feature<NoneFeatureConfiguration> {
    public StrawberryBushFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int size = 2;
        for (int x = -size; x <= size; ++x) {
            for (int y = -size; y <= size; ++y) {
                for (int z = -size; z <= size; ++z) {
                    this.placeBerries(level, origin.relative(direction, x).above(y).relative(direction.getClockWise(), z), 4);
                }
            }
        }
        return true;
    }

    public void placeBerries(WorldGenLevel pLevel, BlockPos pPos, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeBerries(pLevel, pPos);
        }
    }

    public void placeBerries(WorldGenLevel pLevel, BlockPos pPos) {
        if (pLevel.getBlockState(pPos).isAir() && pLevel.getBlockState(pPos.below()).is(BlockTags.DIRT)) {
            if (pLevel.getRandom().nextBoolean()) {
                this.setBlock((LevelWriter)pLevel, pPos, (BlockState)IcariaBlocks.STRAWBERRY_BUSH.get().defaultBlockState().setValue(IcariaBlockStateProperties.RIPE, (Comparable)((Object)Ripe.NONE)));
            } else {
                this.setBlock((LevelWriter)pLevel, pPos, (BlockState)IcariaBlocks.STRAWBERRY_BUSH.get().defaultBlockState().setValue(IcariaBlockStateProperties.RIPE, (Comparable)((Object)Ripe.RIPE)));
            }
        }
    }
}

