/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class YellowstoneBoulderFeature
extends Feature<NoneFeatureConfiguration> {
    public YellowstoneBoulderFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        for (int l = 0; l < 3; ++l) {
            int x = random.nextIntBetweenInclusive(2, 3);
            int y = random.nextIntBetweenInclusive(2, 3);
            int z = random.nextIntBetweenInclusive(2, 3);
            float f = (float)(x + y + z) * 0.333f + 0.5f;
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)origin.offset(-x, -y, -z), (BlockPos)origin.offset(x, y, z))) {
                if (!(blockPos.distSqr((Vec3i)origin) <= (double)(f * f))) continue;
                level.setBlock(blockPos, IcariaBlocks.YELLOWSTONE.get().defaultBlockState(), 3);
            }
            origin = origin.offset(random.nextIntBetweenInclusive(-1, 0), random.nextIntBetweenInclusive(-1, 0), random.nextIntBetweenInclusive(-1, 0));
        }
        return true;
    }

    public void placeStone(WorldGenLevel pLevel, BlockPos pPos, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeStone(pLevel, pPos);
        }
    }

    public void placeStone(WorldGenLevel pLevel, BlockPos pPos) {
        if (pLevel.getBlockState(pPos).isAir()) {
            this.setBlock((LevelWriter)pLevel, pPos, IcariaBlocks.YELLOWSTONE.get().defaultBlockState());
        }
    }
}

