/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.herb;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BolbosFeature
extends Feature<NoneFeatureConfiguration> {
    public BolbosFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int size = 2;
        AABB aabb = AABB.ofSize((Vec3)origin.getCenter(), (double)0.0, (double)16.0, (double)0.0);
        List list = level.getBlockStates(aabb).toList();
        boolean test = list.contains(IcariaBlocks.GRAINITE.get().defaultBlockState());
        for (int x = -size; x <= size; ++x) {
            for (int y = -size; y <= size; ++y) {
                for (int z = -size; z <= size; ++z) {
                    if (!test) continue;
                    this.placeHerb(level, origin.relative(direction, x).above(y).relative(direction.getClockWise(), z), 4);
                    this.placeRubble(level, origin.relative(direction, x).above(y).relative(direction.getClockWise(), z), 4);
                }
            }
        }
        return true;
    }

    public void placeHerb(WorldGenLevel pLevel, BlockPos pPos, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeHerb(pLevel, pPos);
        }
    }

    public void placeHerb(WorldGenLevel pLevel, BlockPos pPos) {
        if (pLevel.getBlockState(pPos).isAir() && pLevel.getBlockState(pPos.below()).is(IcariaBlocks.GRAINEL.get())) {
            this.setBlock((LevelWriter)pLevel, pPos, IcariaBlocks.BOLBOS.get().defaultBlockState());
        }
    }

    public void placeRubble(WorldGenLevel pLevel, BlockPos pPos, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeRubble(pLevel, pPos);
        }
    }

    public void placeRubble(WorldGenLevel pLevel, BlockPos pPos) {
        if (pLevel.getBlockState(pPos).isAir() && pLevel.getBlockState(pPos.below()).is(IcariaBlocks.GRAINEL.get())) {
            this.setBlock((LevelWriter)pLevel, pPos, IcariaBlocks.GRAINITE_RUBBLE.get().defaultBlockState());
        }
    }
}

