/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.hidden;

import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaHiddenFeature
extends Feature<NoneFeatureConfiguration> {
    public Block hidden;
    public Block surface;

    public IcariaHiddenFeature(Codec<NoneFeatureConfiguration> pCodec, Block pHidden, Block pSurface) {
        super(pCodec);
        this.hidden = pHidden;
        this.surface = pSurface;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        this.placeHidden(level, origin.below(2));
        this.placeHidden(level, origin.below(2).north(), 4);
        this.placeHidden(level, origin.below(2).east(), 4);
        this.placeHidden(level, origin.below(2).south(), 4);
        this.placeHidden(level, origin.below(2).west(), 4);
        this.placeSurface(level, origin);
        return true;
    }

    public void placeHidden(WorldGenLevel pLevel, BlockPos pPos, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeHidden(pLevel, pPos);
        }
    }

    public void placeHidden(WorldGenLevel pLevel, BlockPos pPos) {
        if (pLevel.getBlockState(pPos.above()).isSolid() && pLevel.getBlockState(pPos.below()).isSolid() && pLevel.getBlockState(pPos.north()).isSolid() && pLevel.getBlockState(pPos.east()).isSolid() && pLevel.getBlockState(pPos.south()).isSolid() && pLevel.getBlockState(pPos.west()).isSolid()) {
            this.setBlock((LevelWriter)pLevel, pPos, this.hidden.defaultBlockState());
        }
    }

    public void placeSurface(WorldGenLevel pLevel, BlockPos pPos, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeSurface(pLevel, pPos);
        }
    }

    public void placeSurface(WorldGenLevel pLevel, BlockPos pPos) {
        if (pLevel.getBlockState(pPos).isAir()) {
            this.setBlock((LevelWriter)pLevel, pPos, this.surface.defaultBlockState());
        }
    }
}

