/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.lake;

import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaLakeFeature
extends Feature<NoneFeatureConfiguration> {
    public Block block;
    public Block fluid;

    public IcariaLakeFeature(Codec<NoneFeatureConfiguration> pCodec, Block pBlock, Block pFluid) {
        super(pCodec);
        this.block = pBlock;
        this.fluid = pFluid;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        if (origin.getY() <= level.getMinBuildHeight() + 4) {
            return false;
        }
        int a = random.nextInt(4) + 4;
        boolean[] booleans = new boolean[2048];
        BlockState block = this.block.defaultBlockState();
        BlockState fluid = this.fluid.defaultBlockState();
        for (int b = 0; b < a; ++b) {
            double n = random.nextDouble() * 6.0 + 3.0;
            double o = random.nextDouble() * 4.0 + 2.0;
            double p = random.nextDouble() * 6.0 + 3.0;
            double q = random.nextDouble() * (16.0 - n - 2.0) + 1.0 + n / 2.0;
            double r = random.nextDouble() * (8.0 - o - 4.0) + 2.0 + o / 2.0;
            double s = random.nextDouble() * (16.0 - p - 2.0) + 1.0 + p / 2.0;
            for (int c = 1; c < 15; ++c) {
                for (int d = 1; d < 15; ++d) {
                    for (int e = 1; e < 7; ++e) {
                        double t = ((double)c - q) / (n / 2.0);
                        double u = ((double)e - r) / (o / 2.0);
                        double v = ((double)d - s) / (p / 2.0);
                        double w = t * t + u * u + v * v;
                        if (!(w < 1.0)) continue;
                        booleans[(c * 16 + d) * 8 + e] = true;
                    }
                }
            }
        }
        origin = origin.below(4);
        for (int f = 0; f < 16; ++f) {
            for (int g = 0; g < 16; ++g) {
                for (int h = 0; h < 8; ++h) {
                    BlockState blockState = level.getBlockState(origin.offset(f, h, g));
                    if (booleans[(f * 16 + g) * 8 + h] || !(f < 15 && booleans[((f + 1) * 16 + g) * 8 + h] || f > 0 && booleans[((f - 1) * 16 + g) * 8 + h] || g < 15 && booleans[(f * 16 + g + 1) * 8 + h] || g > 0 && booleans[(f * 16 + (g - 1)) * 8 + h] || h < 7 && booleans[(f * 16 + g) * 8 + h + 1]) && (h <= 0 || !booleans[(f * 16 + g) * 8 + (h - 1)])) continue;
                    if (h >= 4 && blockState.liquid()) {
                        return false;
                    }
                    if (h >= 4 || blockState.isSolid() || level.getBlockState(origin.offset(f, h, g)) == fluid) continue;
                    return false;
                }
            }
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 8; ++k) {
                    boolean flag;
                    BlockPos blockPos = origin.offset(i, k, j);
                    if (!booleans[(i * 16 + j) * 8 + k]) continue;
                    boolean bl = flag = k >= 4;
                    if (!this.isReplaced(level, blockPos)) continue;
                    level.setBlock(blockPos, flag ? Blocks.AIR.defaultBlockState() : fluid, 2);
                    if (!flag) continue;
                    level.scheduleTick(blockPos, Blocks.AIR.defaultBlockState().getBlock(), 0);
                    this.markAboveForPostProcessing(level, blockPos);
                }
            }
        }
        for (int j2 = 0; j2 < 16; ++j2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                for (int l3 = 0; l3 < 8; ++l3) {
                    boolean flag;
                    boolean bl = flag = !booleans[(j2 * 16 + j3) * 8 + l3] && (j2 < 15 && booleans[((j2 + 1) * 16 + j3) * 8 + l3] || j2 > 0 && booleans[((j2 - 1) * 16 + j3) * 8 + l3] || j3 < 15 && booleans[(j2 * 16 + j3 + 1) * 8 + l3] || j3 > 0 && booleans[(j2 * 16 + (j3 - 1)) * 8 + l3] || l3 < 7 && booleans[(j2 * 16 + j3) * 8 + l3 + 1] || l3 > 0 && booleans[(j2 * 16 + j3) * 8 + (l3 - 1)]);
                    if (!flag || l3 >= 4 && random.nextInt(2) == 0) continue;
                    BlockPos blockPos = origin.offset(j2, l3, j3);
                    if (!level.getBlockState(origin.offset(j2, l3, j3)).isSolid() || !this.isReplaced(level, origin.offset(j2, l3, j3))) continue;
                    level.setBlock(blockPos, block, 2);
                    this.markAboveForPostProcessing(level, blockPos);
                }
            }
        }
        return true;
    }

    public boolean isReplaced(WorldGenLevel pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos).canBeReplaced() || pLevel.getBlockState(pPos).is(BlockTags.DIRT);
    }
}

