/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.world.feature.pillar;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FallenRelicstonePillarFeature
extends Feature<NoneFeatureConfiguration> {
    public FallenRelicstonePillarFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        BlockPos origin = pContext.origin();
        RandomSource random = pContext.random();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int length = random.nextIntBetweenInclusive(1, 3);
        int offset = 2;
        this.placeHead(level, origin, Direction.UP);
        this.placePillar(level, origin.above(), Direction.UP);
        this.placeRubble(level, origin.relative(direction), 4);
        this.placeRubble(level, origin.relative(direction).relative(direction.getClockWise()), 4);
        this.placeRubble(level, origin.relative(direction).relative(direction.getCounterClockWise()), 4);
        this.placeRubble(level, origin.relative(direction, 2), 4);
        this.placeRubble(level, origin.relative(direction, 2).relative(direction.getClockWise()), 4);
        this.placeRubble(level, origin.relative(direction, 2).relative(direction.getCounterClockWise()), 4);
        for (int i = 1; i <= length; ++i) {
            this.placePillar(level, origin.relative(direction, ++offset), direction);
        }
        this.placeHead(level, origin.relative(direction, ++offset), direction.getOpposite());
        return true;
    }

    public void placeHead(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeHead(pLevel, pPos, pDirection);
        }
    }

    public void placeHead(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection) {
        if (pLevel.getBlockState(pPos).isAir() && pLevel.getBlockState(pPos.below()).is(IcariaBlockTags.DIRT_AND_SAND)) {
            this.setBlock((LevelWriter)pLevel, pPos, (BlockState)IcariaBlocks.RELICSTONE_PILLAR_HEAD.get().defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)pDirection));
        }
    }

    public void placePillar(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placePillar(pLevel, pPos, pDirection);
        }
    }

    public void placePillar(WorldGenLevel pLevel, BlockPos pPos, Direction pDirection) {
        if (pLevel.getBlockState(pPos).isAir() && (pLevel.getBlockState(pPos.below()).is(IcariaBlockTags.DIRT_AND_SAND) || pLevel.getBlockState(pPos.below()).is(IcariaBlocks.RELICSTONE_PILLAR_HEAD.get()))) {
            this.setBlock((LevelWriter)pLevel, pPos, (BlockState)IcariaBlocks.RELICSTONE_PILLAR.get().defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)pDirection.getAxis()));
        }
    }

    public void placeRubble(WorldGenLevel pLevel, BlockPos pPos, int pChance) {
        if (pLevel.getRandom().nextInt(pChance) == 0) {
            this.placeRubble(pLevel, pPos);
        }
    }

    public void placeRubble(WorldGenLevel pLevel, BlockPos pPos) {
        if (pLevel.getBlockState(pPos).isAir() && pLevel.getBlockState(pPos.below()).is(IcariaBlockTags.DIRT_AND_SAND)) {
            this.setBlock((LevelWriter)pLevel, pPos, IcariaBlocks.RELICSTONE_RUBBLE.get().defaultBlockState());
        }
    }
}

